rule win_calmthorn_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.calmthorn."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.calmthorn"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ebbb 0fb68d85fdffff 83f901 7552 c78504edffff00000000 eb0f 8b9504edffff }
            // n = 7, score = 100
            //   ebbb                 | jmp                 0xffffffbd
            //   0fb68d85fdffff       | movzx               ecx, byte ptr [ebp - 0x27b]
            //   83f901               | cmp                 ecx, 1
            //   7552                 | jne                 0x54
            //   c78504edffff00000000     | mov    dword ptr [ebp - 0x12fc], 0
            //   eb0f                 | jmp                 0x11
            //   8b9504edffff         | mov                 edx, dword ptr [ebp - 0x12fc]

        $sequence_1 = { 8b9514f8ffff 0fbe02 85c0 7502 eb02 ebba 0fb68d9efdffff }
            // n = 7, score = 100
            //   8b9514f8ffff         | mov                 edx, dword ptr [ebp - 0x7ec]
            //   0fbe02               | movsx               eax, byte ptr [edx]
            //   85c0                 | test                eax, eax
            //   7502                 | jne                 4
            //   eb02                 | jmp                 4
            //   ebba                 | jmp                 0xffffffbc
            //   0fb68d9efdffff       | movzx               ecx, byte ptr [ebp - 0x262]

        $sequence_2 = { eb0f 8b8d08a7ffff 83c101 898d08a7ffff 8b95c8b5ffff 52 e8???????? }
            // n = 7, score = 100
            //   eb0f                 | jmp                 0x11
            //   8b8d08a7ffff         | mov                 ecx, dword ptr [ebp - 0x58f8]
            //   83c101               | add                 ecx, 1
            //   898d08a7ffff         | mov                 dword ptr [ebp - 0x58f8], ecx
            //   8b95c8b5ffff         | mov                 edx, dword ptr [ebp - 0x4a38]
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_3 = { eb02 ebba 0fb69568fdffff 83fa01 7553 0f57c0 660f1385347affff }
            // n = 7, score = 100
            //   eb02                 | jmp                 4
            //   ebba                 | jmp                 0xffffffbc
            //   0fb69568fdffff       | movzx               edx, byte ptr [ebp - 0x298]
            //   83fa01               | cmp                 edx, 1
            //   7553                 | jne                 0x55
            //   0f57c0               | xorps               xmm0, xmm0
            //   660f1385347affff     | movlpd              qword ptr [ebp - 0x85cc], xmm0

        $sequence_4 = { 8b951c7cffff 83c201 8b85207cffff 83d000 89951c7cffff 8985207cffff 83bd207cffffff }
            // n = 7, score = 100
            //   8b951c7cffff         | mov                 edx, dword ptr [ebp - 0x83e4]
            //   83c201               | add                 edx, 1
            //   8b85207cffff         | mov                 eax, dword ptr [ebp - 0x83e0]
            //   83d000               | adc                 eax, 0
            //   89951c7cffff         | mov                 dword ptr [ebp - 0x83e4], edx
            //   8985207cffff         | mov                 dword ptr [ebp - 0x83e0], eax
            //   83bd207cffffff       | cmp                 dword ptr [ebp - 0x83e0], -1

        $sequence_5 = { 8b953cfaffff 52 e8???????? 83c404 3985b8e7ffff 7d20 8b853cfaffff }
            // n = 7, score = 100
            //   8b953cfaffff         | mov                 edx, dword ptr [ebp - 0x5c4]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   3985b8e7ffff         | cmp                 dword ptr [ebp - 0x1848], eax
            //   7d20                 | jge                 0x22
            //   8b853cfaffff         | mov                 eax, dword ptr [ebp - 0x5c4]

        $sequence_6 = { c785d8aeffff00000000 eb0f 8b85d8aeffff 83c001 8985d8aeffff 8b8db0bcffff 51 }
            // n = 7, score = 100
            //   c785d8aeffff00000000     | mov    dword ptr [ebp - 0x5128], 0
            //   eb0f                 | jmp                 0x11
            //   8b85d8aeffff         | mov                 eax, dword ptr [ebp - 0x5128]
            //   83c001               | add                 eax, 1
            //   8985d8aeffff         | mov                 dword ptr [ebp - 0x5128], eax
            //   8b8db0bcffff         | mov                 ecx, dword ptr [ebp - 0x4350]
            //   51                   | push                ecx

        $sequence_7 = { 8b850899ffff 83d000 89950499ffff 89850899ffff 83bd0899ffff00 7722 720c }
            // n = 7, score = 100
            //   8b850899ffff         | mov                 eax, dword ptr [ebp - 0x66f8]
            //   83d000               | adc                 eax, 0
            //   89950499ffff         | mov                 dword ptr [ebp - 0x66fc], edx
            //   89850899ffff         | mov                 dword ptr [ebp - 0x66f8], eax
            //   83bd0899ffff00       | cmp                 dword ptr [ebp - 0x66f8], 0
            //   7722                 | ja                  0x24
            //   720c                 | jb                  0xe

        $sequence_8 = { eb0f 8b950cb8ffff 83c201 89950cb8ffff 8b85c4daffff 50 e8???????? }
            // n = 7, score = 100
            //   eb0f                 | jmp                 0x11
            //   8b950cb8ffff         | mov                 edx, dword ptr [ebp - 0x47f4]
            //   83c201               | add                 edx, 1
            //   89950cb8ffff         | mov                 dword ptr [ebp - 0x47f4], edx
            //   8b85c4daffff         | mov                 eax, dword ptr [ebp - 0x253c]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_9 = { ebbb 0fb68d73fdffff 83f901 7552 c785cce7ffff00000000 eb0f 8b95cce7ffff }
            // n = 7, score = 100
            //   ebbb                 | jmp                 0xffffffbd
            //   0fb68d73fdffff       | movzx               ecx, byte ptr [ebp - 0x28d]
            //   83f901               | cmp                 ecx, 1
            //   7552                 | jne                 0x54
            //   c785cce7ffff00000000     | mov    dword ptr [ebp - 0x1834], 0
            //   eb0f                 | jmp                 0x11
            //   8b95cce7ffff         | mov                 edx, dword ptr [ebp - 0x1834]

    condition:
        7 of them and filesize < 2322432
}