rule win_camubot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.camubot"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 80bba002000000 7418 6a00 6a00 6807040000 8bc3 e8???????? }
            // n = 7, score = 100
            //   80bba002000000       | cmp                 byte ptr [ebx + 0x2a0], 0
            //   7418                 | je                  0x1a
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6807040000           | push                0x407
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     

        $sequence_1 = { 3c22 3c26 3c42 3c65 3c8a 3cb8 3cc8 }
            // n = 7, score = 100
            //   3c22                 | cmp                 al, 0x22
            //   3c26                 | cmp                 al, 0x26
            //   3c42                 | cmp                 al, 0x42
            //   3c65                 | cmp                 al, 0x65
            //   3c8a                 | cmp                 al, 0x8a
            //   3cb8                 | cmp                 al, 0xb8
            //   3cc8                 | cmp                 al, 0xc8

        $sequence_2 = { c745c8fc1d6000 c745c4ffffffff 33c0 33db 8945e4 8b45f8 8945fc }
            // n = 7, score = 100
            //   c745c8fc1d6000       | mov                 dword ptr [ebp - 0x38], 0x601dfc
            //   c745c4ffffffff       | mov                 dword ptr [ebp - 0x3c], 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   33db                 | xor                 ebx, ebx
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_3 = { 0060af 47 007caf47 0088af4700a4 af 47 00b0af4700cc }
            // n = 7, score = 100
            //   0060af               | add                 byte ptr [eax - 0x51], ah
            //   47                   | inc                 edi
            //   007caf47             | add                 byte ptr [edi + ebp*4 + 0x47], bh
            //   0088af4700a4         | add                 byte ptr [eax - 0x5bffb851], cl
            //   af                   | scasd               eax, dword ptr es:[edi]
            //   47                   | inc                 edi
            //   00b0af4700cc         | add                 byte ptr [eax - 0x33ffb851], dh

        $sequence_4 = { e9???????? 0100 0000 cc c9 41 0025???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   0100                 | add                 dword ptr [eax], eax
            //   0000                 | add                 byte ptr [eax], al
            //   cc                   | int3                
            //   c9                   | leave               
            //   41                   | inc                 ecx
            //   0025????????         |                     

        $sequence_5 = { 00f0 5f 47 000a 60 47 }
            // n = 6, score = 100
            //   00f0                 | add                 al, dh
            //   5f                   | pop                 edi
            //   47                   | inc                 edi
            //   000a                 | add                 byte ptr [edx], cl
            //   60                   | pushal              
            //   47                   | inc                 edi

        $sequence_6 = { 03148d1c526000 8b4814 0fb68960040000 294df4 }
            // n = 4, score = 100
            //   03148d1c526000       | add                 edx, dword ptr [ecx*4 + 0x60521c]
            //   8b4814               | mov                 ecx, dword ptr [eax + 0x14]
            //   0fb68960040000       | movzx               ecx, byte ptr [ecx + 0x460]
            //   294df4               | sub                 dword ptr [ebp - 0xc], ecx

        $sequence_7 = { 007c2d49 00962d4900b0 2d4900ca2d 49 00e4 2d4900fe2d }
            // n = 6, score = 100
            //   007c2d49             | add                 byte ptr [ebp + ebp + 0x49], bh
            //   00962d4900b0         | add                 byte ptr [esi - 0x4fffb6d3], dl
            //   2d4900ca2d           | sub                 eax, 0x2dca0049
            //   49                   | dec                 ecx
            //   00e4                 | add                 ah, ah
            //   2d4900fe2d           | sub                 eax, 0x2dfe0049

        $sequence_8 = { 898e80000000 0fb70c8590116000 898e8c000000 0fb70c8594116000 898e90000000 }
            // n = 5, score = 100
            //   898e80000000         | mov                 dword ptr [esi + 0x80], ecx
            //   0fb70c8590116000     | movzx               ecx, word ptr [eax*4 + 0x601190]
            //   898e8c000000         | mov                 dword ptr [esi + 0x8c], ecx
            //   0fb70c8594116000     | movzx               ecx, word ptr [eax*4 + 0x601194]
            //   898e90000000         | mov                 dword ptr [esi + 0x90], ecx

        $sequence_9 = { 0fb645fb 8b1c85e4516000 b806000000 8bd3 d1fa 7903 83d200 }
            // n = 7, score = 100
            //   0fb645fb             | movzx               eax, byte ptr [ebp - 5]
            //   8b1c85e4516000       | mov                 ebx, dword ptr [eax*4 + 0x6051e4]
            //   b806000000           | mov                 eax, 6
            //   8bd3                 | mov                 edx, ebx
            //   d1fa                 | sar                 edx, 1
            //   7903                 | jns                 5
            //   83d200               | adc                 edx, 0

    condition:
        7 of them and filesize < 31375360
}