rule win_cannon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cannon"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff08 0891ff080891 ff08 0891ff080891 ff08 0891ff080891 ff01 }
            // n = 7, score = 100
            //   ff08                 | dec                 dword ptr [eax]
            //   0891ff080891         | or                  byte ptr [ecx - 0x6ef7f701], dl
            //   ff08                 | dec                 dword ptr [eax]
            //   0891ff080891         | or                  byte ptr [ecx - 0x6ef7f701], dl
            //   ff08                 | dec                 dword ptr [eax]
            //   0891ff080891         | or                  byte ptr [ecx - 0x6ef7f701], dl
            //   ff01                 | inc                 dword ptr [ecx]

        $sequence_1 = { e1fe e7e5 e1ff e7e5 e1ff e7e5 }
            // n = 6, score = 100
            //   e1fe                 | loope               0
            //   e7e5                 | out                 0xe5, eax
            //   e1ff                 | loope               1
            //   e7e5                 | out                 0xe5, eax
            //   e1ff                 | loope               1
            //   e7e5                 | out                 0xe5, eax

        $sequence_2 = { c2c2c2 c2c2c2 c2c2a9 c2c2a9 c2c2a9 c2c2a9 }
            // n = 6, score = 100
            //   c2c2c2               | ret                 0xc2c2
            //   c2c2c2               | ret                 0xc2c2
            //   c2c2a9               | ret                 0xa9c2
            //   c2c2a9               | ret                 0xa9c2
            //   c2c2a9               | ret                 0xa9c2
            //   c2c2a9               | ret                 0xa9c2

        $sequence_3 = { e7e5 e1ff e7e5 e1fe e7e5 e1ff e7e5 }
            // n = 7, score = 100
            //   e7e5                 | out                 0xe5, eax
            //   e1ff                 | loope               1
            //   e7e5                 | out                 0xe5, eax
            //   e1fe                 | loope               0
            //   e7e5                 | out                 0xe5, eax
            //   e1ff                 | loope               1
            //   e7e5                 | out                 0xe5, eax

        $sequence_4 = { e1fe e7e5 e1ff e7e5 e1ff }
            // n = 5, score = 100
            //   e1fe                 | loope               0
            //   e7e5                 | out                 0xe5, eax
            //   e1ff                 | loope               1
            //   e7e5                 | out                 0xe5, eax
            //   e1ff                 | loope               1

        $sequence_5 = { ff08 0891ff080891 ff08 0891ff080891 ff08 }
            // n = 5, score = 100
            //   ff08                 | dec                 dword ptr [eax]
            //   0891ff080891         | or                  byte ptr [ecx - 0x6ef7f701], dl
            //   ff08                 | dec                 dword ptr [eax]
            //   0891ff080891         | or                  byte ptr [ecx - 0x6ef7f701], dl
            //   ff08                 | dec                 dword ptr [eax]

        $sequence_6 = { e1ff e7e5 e1ff e7e5 }
            // n = 4, score = 100
            //   e1ff                 | loope               1
            //   e7e5                 | out                 0xe5, eax
            //   e1ff                 | loope               1
            //   e7e5                 | out                 0xe5, eax

        $sequence_7 = { e1ff e7e5 e1fe e7e5 e1ff }
            // n = 5, score = 100
            //   e1ff                 | loope               1
            //   e7e5                 | out                 0xe5, eax
            //   e1fe                 | loope               0
            //   e7e5                 | out                 0xe5, eax
            //   e1ff                 | loope               1

        $sequence_8 = { ff08 0891ff080891 ff01 018eff00008d ff8180bfffed }
            // n = 5, score = 100
            //   ff08                 | dec                 dword ptr [eax]
            //   0891ff080891         | or                  byte ptr [ecx - 0x6ef7f701], dl
            //   ff01                 | inc                 dword ptr [ecx]
            //   018eff00008d         | add                 dword ptr [esi - 0x72ffff01], ecx
            //   ff8180bfffed         | inc                 dword ptr [ecx - 0x12004080]

        $sequence_9 = { e1ff e7e5 e1fe e7e5 e1ff e7e5 e1ff }
            // n = 7, score = 100
            //   e1ff                 | loope               1
            //   e7e5                 | out                 0xe5, eax
            //   e1fe                 | loope               0
            //   e7e5                 | out                 0xe5, eax
            //   e1ff                 | loope               1
            //   e7e5                 | out                 0xe5, eax
            //   e1ff                 | loope               1

    condition:
        7 of them and filesize < 704512
}