rule win_carbanak_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.carbanak."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.carbanak"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 3d2c5c0700 750a e8???????? e9???????? }
            // n = 5, score = 500
            //   e9????????           |                     
            //   3d2c5c0700           | cmp                 eax, 0x75c2c
            //   750a                 | jne                 0xc
            //   e8????????           |                     
            //   e9????????           |                     

        $sequence_1 = { 85c0 7509 e8???????? b001 }
            // n = 4, score = 500
            //   85c0                 | test                eax, eax
            //   7509                 | jne                 0xb
            //   e8????????           |                     
            //   b001                 | mov                 al, 1

        $sequence_2 = { 7c0d e8???????? 84c0 7504 33c0 }
            // n = 5, score = 500
            //   7c0d                 | jl                  0xf
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7504                 | jne                 6
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { 7907 32c0 e9???????? 7507 b001 }
            // n = 5, score = 500
            //   7907                 | jns                 9
            //   32c0                 | xor                 al, al
            //   e9????????           |                     
            //   7507                 | jne                 9
            //   b001                 | mov                 al, 1

        $sequence_4 = { ba31af8402 8d6b09 8bcd e8???????? 33d2 33c9 }
            // n = 6, score = 300
            //   ba31af8402           | mov                 edx, 0x284af31
            //   8d6b09               | lea                 ebp, [ebx + 9]
            //   8bcd                 | mov                 ecx, ebp
            //   e8????????           |                     
            //   33d2                 | xor                 edx, edx
            //   33c9                 | xor                 ecx, ecx

        $sequence_5 = { 450f44fc e8???????? 488b8d20010000 ffd0 488d4c2460 }
            // n = 5, score = 300
            //   450f44fc             | dec                 ecx
            //   e8????????           |                     
            //   488b8d20010000       | mov                 esi, eax
            //   ffd0                 | inc                 ecx
            //   488d4c2460           | or                  ecx, 0xffffffff

        $sequence_6 = { 4183c9ff 4d8bc7 488bc8 458d7921 418bd7 e8???????? }
            // n = 6, score = 300
            //   4183c9ff             | mov                 ebp, esp
            //   4d8bc7               | dec                 eax
            //   488bc8               | sub                 esp, 0x40
            //   458d7921             | inc                 ecx
            //   418bd7               | mov                 edi, ecx
            //   e8????????           |                     

        $sequence_7 = { 8b8614020000 8b4d10 83c40c 40 69c084000000 890c30 }
            // n = 6, score = 200
            //   8b8614020000         | add                 eax, 0x27
            //   8b4d10               | sub                 edx, ecx
            //   83c40c               | sub                 ecx, 0x1021
            //   40                   | mov                 eax, ecx
            //   69c084000000         | sar                 eax, 0xe
            //   890c30               | ret                 

        $sequence_8 = { e8???????? 8b00 8b7004 eb0b c6043e00 46 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   8b00                 | je                  0xa
            //   8b7004               | test                eax, eax
            //   eb0b                 | jg                  7
            //   c6043e00             | add                 eax, 0x61
            //   46                   | jmp                 5

        $sequence_9 = { 8d8d2cfeffff e8???????? ff35???????? 8d45fc 50 e8???????? }
            // n = 6, score = 200
            //   8d8d2cfeffff         | lea                 eax, [ecx + 0x20]
            //   e8????????           |                     
            //   ff35????????         |                     
            //   8d45fc               | cmp                 al, 0x1f
            //   50                   | ja                  0xc
            //   e8????????           |                     

        $sequence_10 = { 56 8b7510 8bc6 83e001 83e602 57 }
            // n = 6, score = 200
            //   56                   | jne                 7
            //   8b7510               | mov                 eax, dword ptr [esi + 8]
            //   8bc6                 | jmp                 4
            //   83e001               | mov                 eax, ebx
            //   83e602               | call                eax
            //   57                   | cmp                 eax, 0xb7

    condition:
        7 of them and filesize < 658432
}