rule win_carberp_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.carberp."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.carberp"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff7704 e8???????? 8bf0 59 59 3bf3 0f8492000000 }
            // n = 7, score = 200
            //   ff7704               | push                dword ptr [edi + 4]
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   3bf3                 | cmp                 esi, ebx
            //   0f8492000000         | je                  0x98

        $sequence_1 = { 7504 0fb611 41 33f6 8ac2 2c30 3c09 }
            // n = 7, score = 200
            //   7504                 | jne                 6
            //   0fb611               | movzx               edx, byte ptr [ecx]
            //   41                   | inc                 ecx
            //   33f6                 | xor                 esi, esi
            //   8ac2                 | mov                 al, dl
            //   2c30                 | sub                 al, 0x30
            //   3c09                 | cmp                 al, 9

        $sequence_2 = { c645eb73 c645ec2e c645ed70 c645ee6c c645ef75 c645f067 c645f100 }
            // n = 7, score = 200
            //   c645eb73             | mov                 byte ptr [ebp - 0x15], 0x73
            //   c645ec2e             | mov                 byte ptr [ebp - 0x14], 0x2e
            //   c645ed70             | mov                 byte ptr [ebp - 0x13], 0x70
            //   c645ee6c             | mov                 byte ptr [ebp - 0x12], 0x6c
            //   c645ef75             | mov                 byte ptr [ebp - 0x11], 0x75
            //   c645f067             | mov                 byte ptr [ebp - 0x10], 0x67
            //   c645f100             | mov                 byte ptr [ebp - 0xf], 0

        $sequence_3 = { 0f8565010000 57 56 e8???????? 59 53 be80000000 }
            // n = 7, score = 200
            //   0f8565010000         | jne                 0x16b
            //   57                   | push                edi
            //   56                   | push                esi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   53                   | push                ebx
            //   be80000000           | mov                 esi, 0x80

        $sequence_4 = { 59 8975fc 3bf7 7507 32c0 e9???????? 53 }
            // n = 7, score = 200
            //   59                   | pop                 ecx
            //   8975fc               | mov                 dword ptr [ebp - 4], esi
            //   3bf7                 | cmp                 esi, edi
            //   7507                 | jne                 9
            //   32c0                 | xor                 al, al
            //   e9????????           |                     
            //   53                   | push                ebx

        $sequence_5 = { ff750c e8???????? ff7510 8d4e24 ff750c e8???????? 5e }
            // n = 7, score = 200
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   e8????????           |                     
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   8d4e24               | lea                 ecx, [esi + 0x24]
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   e8????????           |                     
            //   5e                   | pop                 esi

        $sequence_6 = { 59 84c0 7526 57 68???????? 8d4e1c 897df0 }
            // n = 7, score = 200
            //   59                   | pop                 ecx
            //   84c0                 | test                al, al
            //   7526                 | jne                 0x28
            //   57                   | push                edi
            //   68????????           |                     
            //   8d4e1c               | lea                 ecx, [esi + 0x1c]
            //   897df0               | mov                 dword ptr [ebp - 0x10], edi

        $sequence_7 = { 55 8b6c2428 56 57 8bf8 8b442434 49 }
            // n = 7, score = 200
            //   55                   | push                ebp
            //   8b6c2428             | mov                 ebp, dword ptr [esp + 0x28]
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf8                 | mov                 edi, eax
            //   8b442434             | mov                 eax, dword ptr [esp + 0x34]
            //   49                   | dec                 ecx

        $sequence_8 = { ff742410 6a03 6a00 50 e8???????? 83c414 }
            // n = 6, score = 200
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   6a03                 | push                3
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14

        $sequence_9 = { ff75fc e8???????? 59 385d0f 0f843c010000 e8???????? 84c0 }
            // n = 7, score = 200
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   385d0f               | cmp                 byte ptr [ebp + 0xf], bl
            //   0f843c010000         | je                  0x142
            //   e8????????           |                     
            //   84c0                 | test                al, al

    condition:
        7 of them and filesize < 491520
}