rule win_cerber_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.cerber."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cerber"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff36 ff15???????? 899e14010000 eb06 }
            // n = 4, score = 1200
            //   ff36                 | push                dword ptr [esi]
            //   ff15????????         |                     
            //   899e14010000         | mov                 dword ptr [esi + 0x114], ebx
            //   eb06                 | jmp                 8

        $sequence_1 = { 85c9 7435 8b550c 8d3c8a 8b4d08 2bca 894df4 }
            // n = 7, score = 1200
            //   85c9                 | test                ecx, ecx
            //   7435                 | je                  0x37
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   8d3c8a               | lea                 edi, [edx + ecx*4]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   2bca                 | sub                 ecx, edx
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx

        $sequence_2 = { 8b7d10 eb04 83248b00 85c9 }
            // n = 4, score = 1200
            //   8b7d10               | mov                 edi, dword ptr [ebp + 0x10]
            //   eb04                 | jmp                 6
            //   83248b00             | and                 dword ptr [ebx + ecx*4], 0
            //   85c9                 | test                ecx, ecx

        $sequence_3 = { 85c0 7427 52 e8???????? 59 85c0 }
            // n = 6, score = 1200
            //   85c0                 | test                eax, eax
            //   7427                 | je                  0x29
            //   52                   | push                edx
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax

        $sequence_4 = { 7c28 8bc1 3bc1 7522 8b8cc3f03b0000 }
            // n = 5, score = 1200
            //   7c28                 | jl                  0x2a
            //   8bc1                 | mov                 eax, ecx
            //   3bc1                 | cmp                 eax, ecx
            //   7522                 | jne                 0x24
            //   8b8cc3f03b0000       | mov                 ecx, dword ptr [ebx + eax*8 + 0x3bf0]

        $sequence_5 = { 3b8374010000 7e06 898374010000 ff7510 50 53 e8???????? }
            // n = 7, score = 1200
            //   3b8374010000         | cmp                 eax, dword ptr [ebx + 0x174]
            //   7e06                 | jle                 8
            //   898374010000         | mov                 dword ptr [ebx + 0x174], eax
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   e8????????           |                     

        $sequence_6 = { d3ee 85c9 7414 ff7514 51 ff7508 }
            // n = 6, score = 1200
            //   d3ee                 | shr                 esi, cl
            //   85c9                 | test                ecx, ecx
            //   7414                 | je                  0x16
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   51                   | push                ecx
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_7 = { 8b5d08 8bc3 c1e002 50 ff750c e8???????? }
            // n = 6, score = 1200
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   8bc3                 | mov                 eax, ebx
            //   c1e002               | shl                 eax, 2
            //   50                   | push                eax
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 573440
}