rule win_chaperone_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.chaperone."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.chaperone"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4c2458 488b442448 4803c1 4889442448 c644247833 c6442479c0 }
            // n = 6, score = 100
            //   8b4c2458             | xor                 edx, eax
            //   488b442448           | dec                 eax
            //   4803c1               | mov                 ecx, dword ptr [esp + 0x28]
            //   4889442448           | dec                 eax
            //   c644247833           | mov                 eax, dword ptr [esp + 0x50]
            //   c6442479c0           | dec                 eax

        $sequence_1 = { b924000000 f3a4 488d4c2438 e8???????? 488d542438 488d4c2460 }
            // n = 6, score = 100
            //   b924000000           | dec                 eax
            //   f3a4                 | mov                 eax, dword ptr [esp + 0x398]
            //   488d4c2438           | inc                 ebp
            //   e8????????           |                     
            //   488d542438           | xor                 eax, eax
            //   488d4c2460           | mov                 edx, 1

        $sequence_2 = { 83c001 8944243c 8b442438 3944243c 0f8345010000 8b44243c 8b4c8440 }
            // n = 7, score = 100
            //   83c001               | dec                 eax
            //   8944243c             | sub                 esp, 0x28
            //   8b442438             | dec                 eax
            //   3944243c             | test                eax, eax
            //   0f8345010000         | jne                 0x10af
            //   8b44243c             | dec                 eax
            //   8b4c8440             | lea                 eax, [0x1c267]

        $sequence_3 = { e8???????? 4889442428 488d7c2438 488d3547af0000 b924000000 f3a4 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   4889442428           | cmp                 dword ptr [esp + 0x30], 0
            //   488d7c2438           | je                  0x1af9
            //   488d3547af0000       | dec                 eax
            //   b924000000           | cmp                 dword ptr [esp + 0x738], -1
            //   f3a4                 | jne                 0x1b05

        $sequence_4 = { e8???????? 41b801000000 488d542430 488b4c2468 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   41b801000000         | arpl                word ptr [esp + 0x20], dx
            //   488d542430           | dec                 eax
            //   488b4c2468           | mov                 ecx, dword ptr [esp + 0x40]

        $sequence_5 = { c78424c80100000b000000 488d542468 488b8c2480030000 ff15???????? 488905???????? }
            // n = 5, score = 100
            //   c78424c80100000b000000     | dec    eax
            //   488d542468           | lea                 eax, [esp + 0x268]
            //   488b8c2480030000     | dec                 eax
            //   ff15????????         |                     
            //   488905????????       |                     

        $sequence_6 = { 85c0 740d 488b4c2420 0fb7442440 668901 488b4c2430 e8???????? }
            // n = 7, score = 100
            //   85c0                 | dec                 eax
            //   740d                 | lea                 eax, [0x1b5a4]
            //   488b4c2420           | dec                 eax
            //   0fb7442440           | mov                 dword ptr [ecx + 0xb8], eax
            //   668901               | mov                 dword ptr [esp + 8], 0
            //   488b4c2430           | jmp                 0x1cf3
            //   e8????????           |                     

        $sequence_7 = { 33c0 eb68 c744243801000000 488b442430 }
            // n = 4, score = 100
            //   33c0                 | dec                 eax
            //   eb68                 | mov                 ecx, dword ptr [esp + 0x268]
            //   c744243801000000     | dec                 eax
            //   488b442430           | xor                 ecx, esp

        $sequence_8 = { 33db 488bf8 48391d???????? 0f85d0000000 488d0d4fb50000 ff15???????? 488bf0 }
            // n = 7, score = 100
            //   33db                 | mov                 dword ptr [esp + 0x1c8], 7
            //   488bf8               | dec                 eax
            //   48391d????????       |                     
            //   0f85d0000000         | mov                 ecx, dword ptr [esp + 0x380]
            //   488d0d4fb50000       | jne                 0x17cd
            //   ff15????????         |                     
            //   488bf0               | mov                 dword ptr [esp + 0x1c8], 8

        $sequence_9 = { c3 48895c2408 57 4883ec20 488d1da3940100 bf0a000000 }
            // n = 6, score = 100
            //   c3                   | dec                 eax
            //   48895c2408           | mov                 eax, dword ptr [esp + 0x5b8]
            //   57                   | cmp                 dword ptr [eax], 3
            //   4883ec20             | jne                 0x68e
            //   488d1da3940100       | xor                 eax, eax
            //   bf0a000000           | dec                 eax

    condition:
        7 of them and filesize < 373760
}