rule win_cheesetray_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.cheesetray."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cheesetray"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83b8a400000000 894d10 7666 8b88a0000000 8b0419 03cb 85c0 }
            // n = 7, score = 200
            //   83b8a400000000       | cmp                 dword ptr [eax + 0xa4], 0
            //   894d10               | mov                 dword ptr [ebp + 0x10], ecx
            //   7666                 | jbe                 0x68
            //   8b88a0000000         | mov                 ecx, dword ptr [eax + 0xa0]
            //   8b0419               | mov                 eax, dword ptr [ecx + ebx]
            //   03cb                 | add                 ecx, ebx
            //   85c0                 | test                eax, eax

        $sequence_1 = { 56 57 8d0c00 51 6a00 52 c745f800000000 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   57                   | push                edi
            //   8d0c00               | lea                 ecx, [eax + eax]
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   52                   | push                edx
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0

        $sequence_2 = { 0f8489000000 83f8fc 0f8480000000 8b4618 894508 8d5001 8a08 }
            // n = 7, score = 200
            //   0f8489000000         | je                  0x8f
            //   83f8fc               | cmp                 eax, -4
            //   0f8480000000         | je                  0x86
            //   8b4618               | mov                 eax, dword ptr [esi + 0x18]
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   8d5001               | lea                 edx, [eax + 1]
            //   8a08                 | mov                 cl, byte ptr [eax]

        $sequence_3 = { c785c8f2ffff18104400 bb05000000 895704 eb22 83f8ff }
            // n = 5, score = 200
            //   c785c8f2ffff18104400     | mov    dword ptr [ebp - 0xd38], 0x441018
            //   bb05000000           | mov                 ebx, 5
            //   895704               | mov                 dword ptr [edi + 4], edx
            //   eb22                 | jmp                 0x24
            //   83f8ff               | cmp                 eax, -1

        $sequence_4 = { bb01000000 019ea0160000 0fb690b02b4400 66019c9698040000 8d849698040000 81c1ffff0000 b800010000 }
            // n = 7, score = 200
            //   bb01000000           | mov                 ebx, 1
            //   019ea0160000         | add                 dword ptr [esi + 0x16a0], ebx
            //   0fb690b02b4400       | movzx               edx, byte ptr [eax + 0x442bb0]
            //   66019c9698040000     | add                 word ptr [esi + edx*4 + 0x498], bx
            //   8d849698040000       | lea                 eax, [esi + edx*4 + 0x498]
            //   81c1ffff0000         | add                 ecx, 0xffff
            //   b800010000           | mov                 eax, 0x100

        $sequence_5 = { 83c410 85c0 0f84a2000000 56 57 6a0a }
            // n = 6, score = 200
            //   83c410               | add                 esp, 0x10
            //   85c0                 | test                eax, eax
            //   0f84a2000000         | je                  0xa8
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a0a                 | push                0xa

        $sequence_6 = { 1bcf 894508 0bc1 894d0c 75a2 5f }
            // n = 6, score = 200
            //   1bcf                 | sbb                 ecx, edi
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   0bc1                 | or                  eax, ecx
            //   894d0c               | mov                 dword ptr [ebp + 0xc], ecx
            //   75a2                 | jne                 0xffffffa4
            //   5f                   | pop                 edi

        $sequence_7 = { 8b7d08 8bc7 c1f805 8bf7 83e61f c1e606 03348580ce4400 }
            // n = 7, score = 200
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8bc7                 | mov                 eax, edi
            //   c1f805               | sar                 eax, 5
            //   8bf7                 | mov                 esi, edi
            //   83e61f               | and                 esi, 0x1f
            //   c1e606               | shl                 esi, 6
            //   03348580ce4400       | add                 esi, dword ptr [eax*4 + 0x44ce80]

        $sequence_8 = { 33c9 03f0 13ca 8935???????? 890d???????? eb17 8bc8 }
            // n = 7, score = 200
            //   33c9                 | xor                 ecx, ecx
            //   03f0                 | add                 esi, eax
            //   13ca                 | adc                 ecx, edx
            //   8935????????         |                     
            //   890d????????         |                     
            //   eb17                 | jmp                 0x19
            //   8bc8                 | mov                 ecx, eax

        $sequence_9 = { a1???????? 8b0f 83c40c 50 6a3b 51 }
            // n = 6, score = 200
            //   a1????????           |                     
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   83c40c               | add                 esp, 0xc
            //   50                   | push                eax
            //   6a3b                 | push                0x3b
            //   51                   | push                ecx

    condition:
        7 of them and filesize < 8626176
}