rule win_chthonic_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.chthonic."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.chthonic"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b10 8911 0fb64dff 46 }
            // n = 4, score = 600
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   8911                 | mov                 dword ptr [ecx], edx
            //   0fb64dff             | movzx               ecx, byte ptr [ebp - 1]
            //   46                   | inc                 esi

        $sequence_1 = { 6a04 56 8d4604 68fc0f0000 }
            // n = 4, score = 600
            //   6a04                 | push                4
            //   56                   | push                esi
            //   8d4604               | lea                 eax, [esi + 4]
            //   68fc0f0000           | push                0xffc

        $sequence_2 = { 81e1ff00ff00 0bc1 89470c 5f }
            // n = 4, score = 600
            //   81e1ff00ff00         | and                 ecx, 0xff00ff
            //   0bc1                 | or                  eax, ecx
            //   89470c               | mov                 dword ptr [edi + 0xc], eax
            //   5f                   | pop                 edi

        $sequence_3 = { 32cb 80e17f 8808 b001 5b c3 }
            // n = 6, score = 600
            //   32cb                 | xor                 cl, bl
            //   80e17f               | and                 cl, 0x7f
            //   8808                 | mov                 byte ptr [eax], cl
            //   b001                 | mov                 al, 1
            //   5b                   | pop                 ebx
            //   c3                   | ret                 

        $sequence_4 = { 8911 8b00 8b4d08 03c2 25ff000080 7907 48 }
            // n = 7, score = 600
            //   8911                 | mov                 dword ptr [ecx], edx
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   03c2                 | add                 eax, edx
            //   25ff000080           | and                 eax, 0x800000ff
            //   7907                 | jns                 9
            //   48                   | dec                 eax

        $sequence_5 = { ff751c ff7518 ff7514 53 ff7510 ff7508 e8???????? }
            // n = 7, score = 600
            //   ff751c               | push                dword ptr [ebp + 0x1c]
            //   ff7518               | push                dword ptr [ebp + 0x18]
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   53                   | push                ebx
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     

        $sequence_6 = { b8ecff0000 660145f0 8d45f0 50 56 e8???????? }
            // n = 6, score = 600
            //   b8ecff0000           | mov                 eax, 0xffec
            //   660145f0             | add                 word ptr [ebp - 0x10], ax
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_7 = { 4e 81ce00ffffff 46 8d84b5fcfbffff 8b08 03f9 81e7ff000080 }
            // n = 7, score = 600
            //   4e                   | dec                 esi
            //   81ce00ffffff         | or                  esi, 0xffffff00
            //   46                   | inc                 esi
            //   8d84b5fcfbffff       | lea                 eax, [ebp + esi*4 - 0x404]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   03f9                 | add                 edi, ecx
            //   81e7ff000080         | and                 edi, 0x800000ff

        $sequence_8 = { 83e601 eb00 85f6 74cf 8345fc02 b9000d0000 }
            // n = 6, score = 600
            //   83e601               | and                 esi, 1
            //   eb00                 | jmp                 2
            //   85f6                 | test                esi, esi
            //   74cf                 | je                  0xffffffd1
            //   8345fc02             | add                 dword ptr [ebp - 4], 2
            //   b9000d0000           | mov                 ecx, 0xd00

        $sequence_9 = { c1c108 81e1ff00ff00 0bc1 89470c }
            // n = 4, score = 600
            //   c1c108               | rol                 ecx, 8
            //   81e1ff00ff00         | and                 ecx, 0xff00ff
            //   0bc1                 | or                  eax, ecx
            //   89470c               | mov                 dword ptr [edi + 0xc], eax

    condition:
        7 of them and filesize < 425984
}