rule win_cloudburst_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.cloudburst."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cloudburst"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488b4508 498bcd 4889442428 e8???????? b904000000 }
            // n = 5, score = 300
            //   488b4508             | dec                 eax
            //   498bcd               | mov                 ebx, dword ptr [esp + 0x50]
            //   4889442428           | jl                  0x47c
            //   e8????????           |                     
            //   b904000000           | dec                 eax

        $sequence_1 = { 45894c2424 418bf9 4133f8 4433df 41897c2428 45895c242c 418bc3 }
            // n = 7, score = 300
            //   45894c2424           | mov                 byte ptr [esp + ebx*8 + 1], dh
            //   418bf9               | jmp                 0x199
            //   4133f8               | dec                 ecx
            //   4433df               | mov                 dword ptr [esi + ebx*8 + 0x10], 0
            //   41897c2428           | dec                 eax
            //   45895c242c           | mov                 ecx, dword ptr [esi]
            //   418bc3               | dec                 eax

        $sequence_2 = { 7205 80f97a 7614 80f941 }
            // n = 4, score = 300
            //   7205                 | lea                 ecx, [0x4f861]
            //   80f97a               | dec                 eax
            //   7614                 | mov                 dword ptr [esp + 0x58], eax
            //   80f941               | dec                 eax

        $sequence_3 = { 33d6 41891424 4133d3 33fa 4189542404 33df }
            // n = 6, score = 300
            //   33d6                 | inc                 dword ptr [edi + 0x34]
            //   41891424             | dec                 ecx
            //   4133d3               | mov                 ecx, edi
            //   33fa                 | test                eax, eax
            //   4189542404           | jne                 0x16ca
            //   33df                 | mov                 edx, esi

        $sequence_4 = { 743e 488b0d???????? 4c8d4c2448 488bd7 ff15???????? }
            // n = 5, score = 300
            //   743e                 | add                 ecx, dword ptr [ebx + 0x20]
            //   488b0d????????       |                     
            //   4c8d4c2448           | dec                 eax
            //   488bd7               | arpl                si, cx
            //   ff15????????         |                     

        $sequence_5 = { 448bc3 4533c2 4133e8 45894424f8 41896c24fc 8bc5 c1e810 }
            // n = 7, score = 300
            //   448bc3               | dec                 ecx
            //   4533c2               | cmovae              edx, esi
            //   4133e8               | dec                 eax
            //   45894424f8           | mov                 esi, dword ptr [edi + 0x10]
            //   41896c24fc           | dec                 eax
            //   8bc5                 | cmp                 esi, esi
            //   c1e810               | dec                 eax

        $sequence_6 = { 80f97a 7614 80f941 7205 80f95a 760a 80f930 }
            // n = 7, score = 300
            //   80f97a               | movzx               ecx, word ptr [ebp - 0x1c]
            //   7614                 | mov                 edx, 0xbf01
            //   80f941               | mov                 byte ptr [ebp - 0x1a], 5
            //   7205                 | and                 cx, dx
            //   80f95a               | or                  cx, 1
            //   760a                 | mov                 word ptr [ebp - 0x1c], cx
            //   80f930               | dec                 eax

        $sequence_7 = { 0430 4388441802 83c303 4983c003 41ffc1 }
            // n = 5, score = 300
            //   0430                 | cmp                 byte ptr [ebx + 0x3e], 0
            //   4388441802           | jne                 0x1de
            //   83c303               | dec                 eax
            //   4983c003             | mov                 ecx, dword ptr [ebx + 8]
            //   41ffc1               | je                  0x1f3

        $sequence_8 = { 43895403fa 4183f904 7cc0 418b8700020000 48895c2438 }
            // n = 5, score = 300
            //   43895403fa           | inc                 esp
            //   4183f904             | mov                 eax, ebp
            //   7cc0                 | mov                 eax, 8
            //   418b8700020000       | movsd               qword ptr [ebx + 0x10], xmm6
            //   48895c2438           | mov                 byte ptr [ebx + 0x26], 2

        $sequence_9 = { 8bc6 c1ee10 c1e808 c1e208 }
            // n = 4, score = 300
            //   8bc6                 | lea                 edx, [0xad7cf]
            //   c1ee10               | inc                 ecx
            //   c1e808               | mov                 ecx, 0x7ea0
            //   c1e208               | mov                 ecx, 0x70a

    condition:
        7 of them and filesize < 2363392
}