rule win_cohhoc_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.cohhoc."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cohhoc"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f2ae 8b15???????? 33f6 f7d1 49 03cb }
            // n = 6, score = 300
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   8b15????????         |                     
            //   33f6                 | xor                 esi, esi
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx
            //   03cb                 | add                 ecx, ebx

        $sequence_1 = { b809000000 c1e909 85c9 7e07 d1f9 40 }
            // n = 6, score = 300
            //   b809000000           | mov                 eax, 9
            //   c1e909               | shr                 ecx, 9
            //   85c9                 | test                ecx, ecx
            //   7e07                 | jle                 9
            //   d1f9                 | sar                 ecx, 1
            //   40                   | inc                 eax

        $sequence_2 = { c705????????01000000 c705????????84000000 891d???????? 891d???????? }
            // n = 4, score = 300
            //   c705????????01000000     |     
            //   c705????????84000000     |     
            //   891d????????         |                     
            //   891d????????         |                     

        $sequence_3 = { 8994245c010000 ff15???????? 8d542414 8d442424 52 50 ff15???????? }
            // n = 7, score = 300
            //   8994245c010000       | mov                 dword ptr [esp + 0x15c], edx
            //   ff15????????         |                     
            //   8d542414             | lea                 edx, [esp + 0x14]
            //   8d442424             | lea                 eax, [esp + 0x24]
            //   52                   | push                edx
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_4 = { eb0a 8b75f4 c7451800000000 8b45fc 8b3d???????? }
            // n = 5, score = 300
            //   eb0a                 | jmp                 0xc
            //   8b75f4               | mov                 esi, dword ptr [ebp - 0xc]
            //   c7451800000000       | mov                 dword ptr [ebp + 0x18], 0
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b3d????????         |                     

        $sequence_5 = { 8d9424ac020000 6aff 52 53 53 66ab ffd6 }
            // n = 7, score = 300
            //   8d9424ac020000       | lea                 edx, [esp + 0x2ac]
            //   6aff                 | push                -1
            //   52                   | push                edx
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   ffd6                 | call                esi

        $sequence_6 = { 85c0 740f 8a4c2404 3808 }
            // n = 4, score = 300
            //   85c0                 | test                eax, eax
            //   740f                 | je                  0x11
            //   8a4c2404             | mov                 cl, byte ptr [esp + 4]
            //   3808                 | cmp                 byte ptr [eax], cl

        $sequence_7 = { 56 8bf8 894c241c 89542418 ff15???????? 6a0a 56 }
            // n = 7, score = 300
            //   56                   | push                esi
            //   8bf8                 | mov                 edi, eax
            //   894c241c             | mov                 dword ptr [esp + 0x1c], ecx
            //   89542418             | mov                 dword ptr [esp + 0x18], edx
            //   ff15????????         |                     
            //   6a0a                 | push                0xa
            //   56                   | push                esi

        $sequence_8 = { a1???????? 48 85c0 a3???????? 7f05 bf01000000 6a00 }
            // n = 7, score = 300
            //   a1????????           |                     
            //   48                   | dec                 eax
            //   85c0                 | test                eax, eax
            //   a3????????           |                     
            //   7f05                 | jg                  7
            //   bf01000000           | mov                 edi, 1
            //   6a00                 | push                0

        $sequence_9 = { 33c0 eb05 1bc0 83d8ff 85c0 0f84ba000000 8b4308 }
            // n = 7, score = 300
            //   33c0                 | xor                 eax, eax
            //   eb05                 | jmp                 7
            //   1bc0                 | sbb                 eax, eax
            //   83d8ff               | sbb                 eax, -1
            //   85c0                 | test                eax, eax
            //   0f84ba000000         | je                  0xc0
            //   8b4308               | mov                 eax, dword ptr [ebx + 8]

    condition:
        7 of them and filesize < 253952
}