rule win_coinminer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.coinminer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.coinminer"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bec 83ec10 8955f8 894dfc 56 57 85c9 }
            // n = 7, score = 100
            //   8bec                 | mov                 ebp, esp
            //   83ec10               | sub                 esp, 0x10
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   56                   | push                esi
            //   57                   | push                edi
            //   85c9                 | test                ecx, ecx

        $sequence_1 = { 742e 837d1800 0f85cf020000 6800080000 }
            // n = 4, score = 100
            //   742e                 | je                  0x30
            //   837d1800             | cmp                 dword ptr [ebp + 0x18], 0
            //   0f85cf020000         | jne                 0x2d5
            //   6800080000           | push                0x800

        $sequence_2 = { a3???????? c705????????19c98f00 c705????????73c98f00 c705????????f8c98f00 a3???????? c705????????bdbf8f00 }
            // n = 6, score = 100
            //   a3????????           |                     
            //   c705????????19c98f00     |     
            //   c705????????73c98f00     |     
            //   c705????????f8c98f00     |     
            //   a3????????           |                     
            //   c705????????bdbf8f00     |     

        $sequence_3 = { 8b0cbda05f9a00 f6440e0401 743d 833c0eff 7437 }
            // n = 5, score = 100
            //   8b0cbda05f9a00       | mov                 ecx, dword ptr [edi*4 + 0x9a5fa0]
            //   f6440e0401           | test                byte ptr [esi + ecx + 4], 1
            //   743d                 | je                  0x3f
            //   833c0eff             | cmp                 dword ptr [esi + ecx], -1
            //   7437                 | je                  0x39

        $sequence_4 = { 8935???????? 85c9 7504 85f6 745b 8b7d14 }
            // n = 6, score = 100
            //   8935????????         |                     
            //   85c9                 | test                ecx, ecx
            //   7504                 | jne                 6
            //   85f6                 | test                esi, esi
            //   745b                 | je                  0x5d
            //   8b7d14               | mov                 edi, dword ptr [ebp + 0x14]

        $sequence_5 = { 33c0 0f57c0 6689842450070000 33f6 660f13442440 }
            // n = 5, score = 100
            //   33c0                 | xor                 eax, eax
            //   0f57c0               | xorps               xmm0, xmm0
            //   6689842450070000     | mov                 word ptr [esp + 0x750], ax
            //   33f6                 | xor                 esi, esi
            //   660f13442440         | movlpd              qword ptr [esp + 0x40], xmm0

        $sequence_6 = { c744242400004000 6a00 50 c744243000000000 c744246c00100000 c744247000000000 c744247400f00400 }
            // n = 7, score = 100
            //   c744242400004000     | mov                 dword ptr [esp + 0x24], 0x400000
            //   6a00                 | push                0
            //   50                   | push                eax
            //   c744243000000000     | mov                 dword ptr [esp + 0x30], 0
            //   c744246c00100000     | mov                 dword ptr [esp + 0x6c], 0x1000
            //   c744247000000000     | mov                 dword ptr [esp + 0x70], 0
            //   c744247400f00400     | mov                 dword ptr [esp + 0x74], 0x4f000

        $sequence_7 = { b8???????? c705????????88c88f00 a3???????? c705????????19c98f00 c705????????73c98f00 }
            // n = 5, score = 100
            //   b8????????           |                     
            //   c705????????88c88f00     |     
            //   a3????????           |                     
            //   c705????????19c98f00     |     
            //   c705????????73c98f00     |     

        $sequence_8 = { 7523 e8???????? 8bf8 8bca 893d???????? }
            // n = 5, score = 100
            //   7523                 | jne                 0x25
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   8bca                 | mov                 ecx, edx
            //   893d????????         |                     

        $sequence_9 = { 55 8bec a1???????? 81ec9c010000 }
            // n = 4, score = 100
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   a1????????           |                     
            //   81ec9c010000         | sub                 esp, 0x19c

    condition:
        7 of them and filesize < 1523712
}