rule win_colibri_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.colibri."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.colibri"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb03 8b75f8 a1???????? 8bcb 8d144502000000 e8???????? a1???????? }
            // n = 7, score = 100
            //   eb03                 | jmp                 5
            //   8b75f8               | mov                 esi, dword ptr [ebp - 8]
            //   a1????????           |                     
            //   8bcb                 | mov                 ecx, ebx
            //   8d144502000000       | lea                 edx, [eax*2 + 2]
            //   e8????????           |                     
            //   a1????????           |                     

        $sequence_1 = { 1bc9 81e100008000 51 53 53 ff770c ff7708 }
            // n = 7, score = 100
            //   1bc9                 | sbb                 ecx, ecx
            //   81e100008000         | and                 ecx, 0x800000
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   ff770c               | push                dword ptr [edi + 0xc]
            //   ff7708               | push                dword ptr [edi + 8]

        $sequence_2 = { 03c6 8945f4 85db 7417 8b0cba 03ce e8???????? }
            // n = 7, score = 100
            //   03c6                 | add                 eax, esi
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   85db                 | test                ebx, ebx
            //   7417                 | je                  0x19
            //   8b0cba               | mov                 ecx, dword ptr [edx + edi*4]
            //   03ce                 | add                 ecx, esi
            //   e8????????           |                     

        $sequence_3 = { 33d0 8bc2 c1e80b eb23 0fb706 03d0 }
            // n = 6, score = 100
            //   33d0                 | xor                 edx, eax
            //   8bc2                 | mov                 eax, edx
            //   c1e80b               | shr                 eax, 0xb
            //   eb23                 | jmp                 0x25
            //   0fb706               | movzx               eax, word ptr [esi]
            //   03d0                 | add                 edx, eax

        $sequence_4 = { 33c0 663b4f06 eb70 8b55fc 0fb7c0 6bf028 8b541624 }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   663b4f06             | cmp                 cx, word ptr [edi + 6]
            //   eb70                 | jmp                 0x72
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   0fb7c0               | movzx               eax, ax
            //   6bf028               | imul                esi, eax, 0x28
            //   8b541624             | mov                 edx, dword ptr [esi + edx + 0x24]

        $sequence_5 = { 8d8564fbffff 50 6a05 59 e8???????? }
            // n = 5, score = 100
            //   8d8564fbffff         | lea                 eax, [ebp - 0x49c]
            //   50                   | push                eax
            //   6a05                 | push                5
            //   59                   | pop                 ecx
            //   e8????????           |                     

        $sequence_6 = { 83e801 7448 83e801 0f859f000000 85f6 7433 8bce }
            // n = 7, score = 100
            //   83e801               | sub                 eax, 1
            //   7448                 | je                  0x4a
            //   83e801               | sub                 eax, 1
            //   0f859f000000         | jne                 0xa5
            //   85f6                 | test                esi, esi
            //   7433                 | je                  0x35
            //   8bce                 | mov                 ecx, esi

        $sequence_7 = { 3bce 7363 8b39 85ff 745a 8b4104 8d5108 }
            // n = 7, score = 100
            //   3bce                 | cmp                 ecx, esi
            //   7363                 | jae                 0x65
            //   8b39                 | mov                 edi, dword ptr [ecx]
            //   85ff                 | test                edi, edi
            //   745a                 | je                  0x5c
            //   8b4104               | mov                 eax, dword ptr [ecx + 4]
            //   8d5108               | lea                 edx, [ecx + 8]

        $sequence_8 = { ffd0 85c0 745d 8b4df0 e8???????? 8bf8 }
            // n = 6, score = 100
            //   ffd0                 | call                eax
            //   85c0                 | test                eax, eax
            //   745d                 | je                  0x5f
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_9 = { 6a02 59 e8???????? ba724e4352 8bc8 e8???????? ffd0 }
            // n = 7, score = 100
            //   6a02                 | push                2
            //   59                   | pop                 ecx
            //   e8????????           |                     
            //   ba724e4352           | mov                 edx, 0x52434e72
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   ffd0                 | call                eax

    condition:
        7 of them and filesize < 51200
}