rule win_comebacker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.comebacker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.comebacker"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6683f809 7f04 0430 eb02 }
            // n = 4, score = 500
            //   6683f809             | cmp                 ax, 9
            //   7f04                 | jg                  6
            //   0430                 | add                 al, 0x30
            //   eb02                 | jmp                 4

        $sequence_1 = { 4c8d0556b10300 41b9dc000000 8d4af2 e8???????? }
            // n = 4, score = 400
            //   4c8d0556b10300       | cmp                 edx, dword ptr [esi]
            //   41b9dc000000         | je                  0x2b
            //   8d4af2               | mov                 dword ptr [esp + 0x20], 0x174
            //   e8????????           |                     

        $sequence_2 = { 741e 488bce 488bc6 488d15bf350600 83e11f 48c1f805 }
            // n = 6, score = 400
            //   741e                 | jmp                 0x24
            //   488bce               | mov                 dword ptr [esp + 0x20], 0xff
            //   488bc6               | inc                 ecx
            //   488d15bf350600       | mov                 eax, 0x68
            //   83e11f               | mov                 edx, 0x77
            //   48c1f805             | dec                 esp

        $sequence_3 = { 493b16 7429 c744242074010000 babb000000 4c8d0df6e20300 }
            // n = 5, score = 400
            //   493b16               | lea                 ecx, [0x3f579]
            //   7429                 | je                  0x20
            //   c744242074010000     | dec                 eax
            //   babb000000           | mov                 ecx, esi
            //   4c8d0df6e20300       | dec                 eax

        $sequence_4 = { 668945dd 8845df 66899d20060000 e8???????? }
            // n = 4, score = 400
            //   668945dd             | mov                 eax, esi
            //   8845df               | dec                 eax
            //   66899d20060000       | lea                 edx, [0x635bf]
            //   e8????????           |                     

        $sequence_5 = { 488b742478 48895c2468 4c8bc8 488b842408010000 4889442460 8b8424f8000000 }
            // n = 6, score = 400
            //   488b742478           | dec                 eax
            //   48895c2468           | mov                 esi, dword ptr [esp + 0x78]
            //   4c8bc8               | dec                 eax
            //   488b842408010000     | mov                 dword ptr [esp + 0x68], ebx
            //   4889442460           | dec                 esp
            //   8b8424f8000000       | mov                 ecx, eax

        $sequence_6 = { eb22 c7442420ff000000 41b868000000 ba77000000 4c8d0d79f50300 }
            // n = 5, score = 400
            //   eb22                 | dec                 eax
            //   c7442420ff000000     | mov                 eax, dword ptr [esp + 0x108]
            //   41b868000000         | dec                 eax
            //   ba77000000           | mov                 dword ptr [esp + 0x60], eax
            //   4c8d0d79f50300       | mov                 eax, dword ptr [esp + 0xf8]

        $sequence_7 = { f2ae 48f7d1 488d79ff 488b8c24e0000000 }
            // n = 4, score = 400
            //   f2ae                 | and                 ecx, 0x1f
            //   48f7d1               | dec                 eax
            //   488d79ff             | sar                 eax, 5
            //   488b8c24e0000000     | dec                 ecx

        $sequence_8 = { 83ec44 a1???????? 33c5 8945fc 8b4508 8d55dc }
            // n = 6, score = 100
            //   83ec44               | mov                 dword ptr [esp + 0x20], 0xff
            //   a1????????           |                     
            //   33c5                 | inc                 ecx
            //   8945fc               | mov                 eax, 0x68
            //   8b4508               | mov                 edx, 0x77
            //   8d55dc               | dec                 esp

        $sequence_9 = { 7409 8d04c516d70410 eb23 f6c30c 7409 8d04c514d70410 }
            // n = 6, score = 100
            //   7409                 | dec                 eax
            //   8d04c516d70410       | not                 ecx
            //   eb23                 | dec                 eax
            //   f6c30c               | lea                 edi, [ecx - 1]
            //   7409                 | dec                 eax
            //   8d04c514d70410       | mov                 ecx, dword ptr [esp + 0xe0]

        $sequence_10 = { e8???????? 83c408 8945f8 8b4514 85c0 7416 8d4dec }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c408               | dec                 eax
            //   8945f8               | mov                 eax, dword ptr [esp + 0x108]
            //   8b4514               | dec                 eax
            //   85c0                 | mov                 dword ptr [esp + 0x60], eax
            //   7416                 | mov                 eax, dword ptr [esp + 0xf8]
            //   8d4dec               | jmp                 0x24

        $sequence_11 = { 42 52 56 50 a3???????? }
            // n = 5, score = 100
            //   42                   | lea                 ecx, [0x3f579]
            //   52                   | je                  0x20
            //   56                   | dec                 eax
            //   50                   | mov                 ecx, esi
            //   a3????????           |                     

        $sequence_12 = { 81e7ff000000 8b1cbd38580410 33cb 8b5e08 33cb 33db 8ade }
            // n = 7, score = 100
            //   81e7ff000000         | mov                 edx, 0xbb
            //   8b1cbd38580410       | dec                 esp
            //   33cb                 | lea                 ecx, [0x3e2f6]
            //   8b5e08               | mov                 word ptr [ebp - 0x23], ax
            //   33cb                 | mov                 byte ptr [ebp - 0x21], al
            //   33db                 | mov                 word ptr [ebp + 0x620], bx
            //   8ade                 | repne scasb         al, byte ptr es:[edi]

        $sequence_13 = { 2bc2 6a21 a3???????? e8???????? 83c404 8bf8 33f6 }
            // n = 7, score = 100
            //   2bc2                 | dec                 eax
            //   6a21                 | mov                 eax, esi
            //   a3????????           |                     
            //   e8????????           |                     
            //   83c404               | dec                 eax
            //   8bf8                 | lea                 edx, [0x635bf]
            //   33f6                 | and                 ecx, 0x1f

        $sequence_14 = { 8d95fcf7ffff 68???????? 52 ffd7 8d85fcf7ffff 83c408 8d5002 }
            // n = 7, score = 100
            //   8d95fcf7ffff         | dec                 eax
            //   68????????           |                     
            //   52                   | sar                 eax, 5
            //   ffd7                 | dec                 ecx
            //   8d85fcf7ffff         | cmp                 edx, dword ptr [esi]
            //   83c408               | je                  0x2b
            //   8d5002               | mov                 dword ptr [esp + 0x20], 0x174

    condition:
        7 of them and filesize < 1429504
}