rule win_comlook_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.comlook."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.comlook"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 68???????? 68???????? 8b4df8 8b5178 52 e8???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   68????????           |                     
            //   68????????           |                     
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   8b5178               | mov                 edx, dword ptr [ecx + 0x78]
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_1 = { 8d15ec260810 e8???????? 58 5a 83c418 3bec e8???????? }
            // n = 7, score = 100
            //   8d15ec260810         | lea                 edx, [0x100826ec]
            //   e8????????           |                     
            //   58                   | pop                 eax
            //   5a                   | pop                 edx
            //   83c418               | add                 esp, 0x18
            //   3bec                 | cmp                 ebp, esp
            //   e8????????           |                     

        $sequence_2 = { c644241601 eb28 80be5006000000 740b 8bce e8???????? 84c0 }
            // n = 7, score = 100
            //   c644241601           | mov                 byte ptr [esp + 0x16], 1
            //   eb28                 | jmp                 0x2a
            //   80be5006000000       | cmp                 byte ptr [esi + 0x650], 0
            //   740b                 | je                  0xd
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   84c0                 | test                al, al

        $sequence_3 = { eb95 c745b4ffffffff c745a4ffffffff c745b800000000 c745a800000000 c78574ffffff00000000 eb0f }
            // n = 7, score = 100
            //   eb95                 | jmp                 0xffffff97
            //   c745b4ffffffff       | mov                 dword ptr [ebp - 0x4c], 0xffffffff
            //   c745a4ffffffff       | mov                 dword ptr [ebp - 0x5c], 0xffffffff
            //   c745b800000000       | mov                 dword ptr [ebp - 0x48], 0
            //   c745a800000000       | mov                 dword ptr [ebp - 0x58], 0
            //   c78574ffffff00000000     | mov    dword ptr [ebp - 0x8c], 0
            //   eb0f                 | jmp                 0x11

        $sequence_4 = { e9???????? 8d7c242c e8???????? b302 8d742424 885c2448 e8???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8d7c242c             | lea                 edi, [esp + 0x2c]
            //   e8????????           |                     
            //   b302                 | mov                 bl, 2
            //   8d742424             | lea                 esi, [esp + 0x24]
            //   885c2448             | mov                 byte ptr [esp + 0x48], bl
            //   e8????????           |                     

        $sequence_5 = { e8???????? 8b5308 895608 c645fc03 8d7e0c c70700000000 c7470400000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b5308               | mov                 edx, dword ptr [ebx + 8]
            //   895608               | mov                 dword ptr [esi + 8], edx
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3
            //   8d7e0c               | lea                 edi, [esi + 0xc]
            //   c70700000000         | mov                 dword ptr [edi], 0
            //   c7470400000000       | mov                 dword ptr [edi + 4], 0

        $sequence_6 = { ffd0 3bf4 e8???????? 8945c8 837dc800 740a b804000000 }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   3bf4                 | cmp                 esi, esp
            //   e8????????           |                     
            //   8945c8               | mov                 dword ptr [ebp - 0x38], eax
            //   837dc800             | cmp                 dword ptr [ebp - 0x38], 0
            //   740a                 | je                  0xc
            //   b804000000           | mov                 eax, 4

        $sequence_7 = { c781384a000000000000 8b5508 c782404a000000000000 8b45f8 50 8b4d08 51 }
            // n = 7, score = 100
            //   c781384a000000000000     | mov    dword ptr [ecx + 0x4a38], 0
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   c782404a000000000000     | mov    dword ptr [edx + 0x4a40], 0
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   50                   | push                eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   51                   | push                ecx

        $sequence_8 = { eb07 c745e000000000 8d4dd4 51 6800400000 8b550c 52 }
            // n = 7, score = 100
            //   eb07                 | jmp                 9
            //   c745e000000000       | mov                 dword ptr [ebp - 0x20], 0
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]
            //   51                   | push                ecx
            //   6800400000           | push                0x4000
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   52                   | push                edx

        $sequence_9 = { eb0c 8b4d0c 8b510c 899558ffffff 8b4510 8b8d58ffffff 894808 }
            // n = 7, score = 100
            //   eb0c                 | jmp                 0xe
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8b510c               | mov                 edx, dword ptr [ecx + 0xc]
            //   899558ffffff         | mov                 dword ptr [ebp - 0xa8], edx
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   8b8d58ffffff         | mov                 ecx, dword ptr [ebp - 0xa8]
            //   894808               | mov                 dword ptr [eax + 8], ecx

    condition:
        7 of them and filesize < 4553728
}