rule win_cova_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.cova."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cova"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d7b58 be06000000 488d0525670000 483947f0 }
            // n = 4, score = 100
            //   488d7b58             | mov                 ecx, dword ptr [eax]
            //   be06000000           | dec                 eax
            //   488d0525670000       | mov                 edi, dword ptr [ecx + 0x20]
            //   483947f0             | dec                 eax

        $sequence_1 = { 488d0509820000 483bf8 740e 833f00 }
            // n = 4, score = 100
            //   488d0509820000       | test                eax, eax
            //   483bf8               | je                  0x2fa
            //   740e                 | dec                 eax
            //   833f00               | lea                 ecx, [0x7367]

        $sequence_2 = { 7526 4c8d25bb610000 493bdc 7408 488bcb e8???????? }
            // n = 6, score = 100
            //   7526                 | je                  0x6d7
            //   4c8d25bb610000       | dec                 eax
            //   493bdc               | lea                 ecx, [0xb309]
            //   7408                 | test                eax, eax
            //   488bcb               | je                  0x6d2
            //   e8????????           |                     

        $sequence_3 = { 4288840120a90000 ffc2 ebe1 897c2420 }
            // n = 4, score = 100
            //   4288840120a90000     | push                ebx
            //   ffc2                 | dec                 eax
            //   ebe1                 | sub                 esp, 0x20
            //   897c2420             | mov                 ebx, ecx

        $sequence_4 = { ff5778 488bd8 4885c0 741f ba20bf0200 488bc8 }
            // n = 6, score = 100
            //   ff5778               | call                dword ptr [ebp + 0x30]
            //   488bd8               | dec                 eax
            //   4885c0               | lea                 ecx, [ebp + 0xe0]
            //   741f                 | mov                 edx, esi
            //   ba20bf0200           | dec                 eax
            //   488bc8               | inc                 eax

        $sequence_5 = { 488d15a4300000 41b810200100 488bcd e8???????? }
            // n = 4, score = 100
            //   488d15a4300000       | dec                 eax
            //   41b810200100         | mov                 dword ptr [esp + 0x30], eax
            //   488bcd               | dec                 eax
            //   e8????????           |                     

        $sequence_6 = { 7528 48833d????????00 741e 488d0d09b30000 }
            // n = 4, score = 100
            //   7528                 | dec                 eax
            //   48833d????????00     |                     
            //   741e                 | sub                 edi, ebp
            //   488d0d09b30000       | mov                 al, byte ptr [edi + ebx]

        $sequence_7 = { 488d15564a0000 488d0d374a0000 e8???????? 85c0 755a }
            // n = 5, score = 100
            //   488d15564a0000       | dec                 eax
            //   488d0d374a0000       | mov                 esi, dword ptr [esp + 0x58]
            //   e8????????           |                     
            //   85c0                 | mov                 al, bl
            //   755a                 | movzx               eax, word ptr [ebx + ecx*2 + 0x10]

        $sequence_8 = { 410fb601 48c1e804 8a440438 8841ff 490fbe01 }
            // n = 5, score = 100
            //   410fb601             | mov                 eax, dword ptr [esp + 0x60]
            //   48c1e804             | dec                 eax
            //   8a440438             | mov                 ecx, dword ptr [esp + 0x30]
            //   8841ff               | dec                 eax
            //   490fbe01             | mov                 edx, eax

        $sequence_9 = { 8b0a 4803cf 33c0 eb0c }
            // n = 4, score = 100
            //   8b0a                 | mov                 dword ptr [esp + 0x28], esi
            //   4803cf               | dec                 eax
            //   33c0                 | lea                 edx, [ebp + 0x750]
            //   eb0c                 | dec                 esp

    condition:
        7 of them and filesize < 123904
}