rule win_covid22_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.covid22."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.covid22"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8a4d78 83c40c f6c102 8975dc 897d08 }
            // n = 5, score = 100
            //   8a4d78               | mov                 cl, byte ptr [ebp + 0x78]
            //   83c40c               | add                 esp, 0xc
            //   f6c102               | test                cl, 2
            //   8975dc               | mov                 dword ptr [ebp - 0x24], esi
            //   897d08               | mov                 dword ptr [ebp + 8], edi

        $sequence_1 = { 57 e8???????? 8d7438ff 3bf7 }
            // n = 4, score = 100
            //   57                   | push                edi
            //   e8????????           |                     
            //   8d7438ff             | lea                 esi, [eax + edi - 1]
            //   3bf7                 | cmp                 esi, edi

        $sequence_2 = { 8b3d???????? ffd7 8b4608 85c0 7403 50 ffd7 }
            // n = 7, score = 100
            //   8b3d????????         |                     
            //   ffd7                 | call                edi
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   85c0                 | test                eax, eax
            //   7403                 | je                  5
            //   50                   | push                eax
            //   ffd7                 | call                edi

        $sequence_3 = { 33d9 81e3ff000000 c1e908 330c9df0904000 0fb65801 }
            // n = 5, score = 100
            //   33d9                 | xor                 ebx, ecx
            //   81e3ff000000         | and                 ebx, 0xff
            //   c1e908               | shr                 ecx, 8
            //   330c9df0904000       | xor                 ecx, dword ptr [ebx*4 + 0x4090f0]
            //   0fb65801             | movzx               ebx, byte ptr [eax + 1]

        $sequence_4 = { 89c3 83fb01 7532 ff35???????? }
            // n = 4, score = 100
            //   89c3                 | mov                 ebx, eax
            //   83fb01               | cmp                 ebx, 1
            //   7532                 | jne                 0x34
            //   ff35????????         |                     

        $sequence_5 = { e8???????? 8d0df4b14000 5a e8???????? 8b442414 e8???????? 50 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d0df4b14000         | lea                 ecx, [0x40b1f4]
            //   5a                   | pop                 edx
            //   e8????????           |                     
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   e8????????           |                     
            //   50                   | push                eax

        $sequence_6 = { 83c001 8bce c1e908 330c9df0904000 0fb618 33d9 }
            // n = 6, score = 100
            //   83c001               | add                 eax, 1
            //   8bce                 | mov                 ecx, esi
            //   c1e908               | shr                 ecx, 8
            //   330c9df0904000       | xor                 ecx, dword ptr [ebx*4 + 0x4090f0]
            //   0fb618               | movzx               ebx, byte ptr [eax]
            //   33d9                 | xor                 ebx, ecx

        $sequence_7 = { 8d0d14b24000 e8???????? ba???????? 8d0d18b24000 e8???????? ba???????? }
            // n = 6, score = 100
            //   8d0d14b24000         | lea                 ecx, [0x40b214]
            //   e8????????           |                     
            //   ba????????           |                     
            //   8d0d18b24000         | lea                 ecx, [0x40b218]
            //   e8????????           |                     
            //   ba????????           |                     

        $sequence_8 = { c705????????0a4c4000 c705????????304c4000 c705????????01000000 837d1c00 7507 c7451c00904000 }
            // n = 6, score = 100
            //   c705????????0a4c4000     |     
            //   c705????????304c4000     |     
            //   c705????????01000000     |     
            //   837d1c00             | cmp                 dword ptr [ebp + 0x1c], 0
            //   7507                 | jne                 9
            //   c7451c00904000       | mov                 dword ptr [ebp + 0x1c], 0x409000

        $sequence_9 = { ba???????? 8d0d10b24000 e8???????? ba???????? 8d0d14b24000 }
            // n = 5, score = 100
            //   ba????????           |                     
            //   8d0d10b24000         | lea                 ecx, [0x40b210]
            //   e8????????           |                     
            //   ba????????           |                     
            //   8d0d14b24000         | lea                 ecx, [0x40b214]

    condition:
        7 of them and filesize < 1955840
}