rule win_credraptor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.credraptor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.credraptor"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8b7dfc 8945f8 83f811 0f84a4feffff eb53 837df400 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b7dfc               | mov                 edi, dword ptr [ebp - 4]
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   83f811               | cmp                 eax, 0x11
            //   0f84a4feffff         | je                  0xfffffeaa
            //   eb53                 | jmp                 0x55
            //   837df400             | cmp                 dword ptr [ebp - 0xc], 0

        $sequence_1 = { f7470400040000 7408 8b7f08 897dfc eb24 0fb607 2d9d000000 }
            // n = 7, score = 100
            //   f7470400040000       | test                dword ptr [edi + 4], 0x400
            //   7408                 | je                  0xa
            //   8b7f08               | mov                 edi, dword ptr [edi + 8]
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   eb24                 | jmp                 0x26
            //   0fb607               | movzx               eax, byte ptr [edi]
            //   2d9d000000           | sub                 eax, 0x9d

        $sequence_2 = { e8???????? ff4648 8b45e8 0fb608 80b9????????70 8b7e48 7516 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   ff4648               | inc                 dword ptr [esi + 0x48]
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   0fb608               | movzx               ecx, byte ptr [eax]
            //   80b9????????70       |                     
            //   8b7e48               | mov                 edi, dword ptr [esi + 0x48]
            //   7516                 | jne                 0x18

        $sequence_3 = { ba00080000 83c408 66895112 5f 5e 5b 8be5 }
            // n = 7, score = 100
            //   ba00080000           | mov                 edx, 0x800
            //   83c408               | add                 esp, 8
            //   66895112             | mov                 word ptr [ecx + 0x12], dx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp

        $sequence_4 = { 8b55ec 894804 33c9 c6400300 895008 89480c }
            // n = 6, score = 100
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   894804               | mov                 dword ptr [eax + 4], ecx
            //   33c9                 | xor                 ecx, ecx
            //   c6400300             | mov                 byte ptr [eax + 3], 0
            //   895008               | mov                 dword ptr [eax + 8], edx
            //   89480c               | mov                 dword ptr [eax + 0xc], ecx

        $sequence_5 = { e8???????? 01450c 83c404 f7460400200000 7429 8b4f0c 8d450c }
            // n = 7, score = 100
            //   e8????????           |                     
            //   01450c               | add                 dword ptr [ebp + 0xc], eax
            //   83c404               | add                 esp, 4
            //   f7460400200000       | test                dword ptr [esi + 4], 0x2000
            //   7429                 | je                  0x2b
            //   8b4f0c               | mov                 ecx, dword ptr [edi + 0xc]
            //   8d450c               | lea                 eax, [ebp + 0xc]

        $sequence_6 = { ffd1 83c414 85c0 0f85a2020000 8b45f8 0fb64dfb 53 }
            // n = 7, score = 100
            //   ffd1                 | call                ecx
            //   83c414               | add                 esp, 0x14
            //   85c0                 | test                eax, eax
            //   0f85a2020000         | jne                 0x2a8
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   0fb64dfb             | movzx               ecx, byte ptr [ebp - 5]
            //   53                   | push                ebx

        $sequence_7 = { ebd2 8bc3 c1f805 8d3c85c0814c00 8bf3 83e61f c1e606 }
            // n = 7, score = 100
            //   ebd2                 | jmp                 0xffffffd4
            //   8bc3                 | mov                 eax, ebx
            //   c1f805               | sar                 eax, 5
            //   8d3c85c0814c00       | lea                 edi, [eax*4 + 0x4c81c0]
            //   8bf3                 | mov                 esi, ebx
            //   83e61f               | and                 esi, 0x1f
            //   c1e606               | shl                 esi, 6

        $sequence_8 = { c1e108 0bc8 750a 5f 5e 8d4165 5b }
            // n = 7, score = 100
            //   c1e108               | shl                 ecx, 8
            //   0bc8                 | or                  ecx, eax
            //   750a                 | jne                 0xc
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   8d4165               | lea                 eax, [ecx + 0x65]
            //   5b                   | pop                 ebx

        $sequence_9 = { e8???????? 8b9510ffffff 8bbd00ffffff 0fb6c0 018524ffffff 8d3c17 8bcb }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b9510ffffff         | mov                 edx, dword ptr [ebp - 0xf0]
            //   8bbd00ffffff         | mov                 edi, dword ptr [ebp - 0x100]
            //   0fb6c0               | movzx               eax, al
            //   018524ffffff         | add                 dword ptr [ebp - 0xdc], eax
            //   8d3c17               | lea                 edi, [edi + edx]
            //   8bcb                 | mov                 ecx, ebx

    condition:
        7 of them and filesize < 1728512
}