rule win_cruloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.cruloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cruloader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 75e6 ff7588 ff15???????? 57 ff15???????? 8b4dfc 8bc3 }
            // n = 7, score = 100
            //   75e6                 | jne                 0xffffffe8
            //   ff7588               | push                dword ptr [ebp - 0x78]
            //   ff15????????         |                     
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8bc3                 | mov                 eax, ebx

        $sequence_1 = { 894de0 c745e404324100 e9???????? c745e003000000 c745e410324100 }
            // n = 5, score = 100
            //   894de0               | mov                 dword ptr [ebp - 0x20], ecx
            //   c745e404324100       | mov                 dword ptr [ebp - 0x1c], 0x413204
            //   e9????????           |                     
            //   c745e003000000       | mov                 dword ptr [ebp - 0x20], 3
            //   c745e410324100       | mov                 dword ptr [ebp - 0x1c], 0x413210

        $sequence_2 = { ffd0 8d4598 50 e8???????? 83c404 a3???????? 3b4594 }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   8d4598               | lea                 eax, [ebp - 0x68]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   a3????????           |                     
            //   3b4594               | cmp                 eax, dword ptr [ebp - 0x6c]

        $sequence_3 = { 56 8b35???????? 85f6 7420 6bc618 57 8db8f05b4100 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   8b35????????         |                     
            //   85f6                 | test                esi, esi
            //   7420                 | je                  0x22
            //   6bc618               | imul                eax, esi, 0x18
            //   57                   | push                edi
            //   8db8f05b4100         | lea                 edi, [eax + 0x415bf0]

        $sequence_4 = { d9c9 d9f1 833d????????00 0f851c0e0000 8d0db02f4100 ba1b000000 }
            // n = 6, score = 100
            //   d9c9                 | fxch                st(1)
            //   d9f1                 | fyl2x               
            //   833d????????00       |                     
            //   0f851c0e0000         | jne                 0xe22
            //   8d0db02f4100         | lea                 ecx, [0x412fb0]
            //   ba1b000000           | mov                 edx, 0x1b

        $sequence_5 = { ffb504fdffff ffb5e4fcffff ffd7 8945e8 85c0 7536 ff15???????? }
            // n = 7, score = 100
            //   ffb504fdffff         | push                dword ptr [ebp - 0x2fc]
            //   ffb5e4fcffff         | push                dword ptr [ebp - 0x31c]
            //   ffd7                 | call                edi
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   85c0                 | test                eax, eax
            //   7536                 | jne                 0x38
            //   ff15????????         |                     

        $sequence_6 = { 56 57 8d3c856c5c4100 8b07 83ceff 3bc6 }
            // n = 6, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   8d3c856c5c4100       | lea                 edi, [eax*4 + 0x415c6c]
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   83ceff               | or                  esi, 0xffffffff
            //   3bc6                 | cmp                 eax, esi

        $sequence_7 = { c78518fdffff02000100 bac1b99e64 33c9 e8???????? }
            // n = 4, score = 100
            //   c78518fdffff02000100     | mov    dword ptr [ebp - 0x2e8], 0x10002
            //   bac1b99e64           | mov                 edx, 0x649eb9c1
            //   33c9                 | xor                 ecx, ecx
            //   e8????????           |                     

        $sequence_8 = { ba4c009781 33c9 8bf0 e8???????? babf676bbc 8985bcfdffff 33c9 }
            // n = 7, score = 100
            //   ba4c009781           | mov                 edx, 0x8197004c
            //   33c9                 | xor                 ecx, ecx
            //   8bf0                 | mov                 esi, eax
            //   e8????????           |                     
            //   babf676bbc           | mov                 edx, 0xbc6b67bf
            //   8985bcfdffff         | mov                 dword ptr [ebp - 0x244], eax
            //   33c9                 | xor                 ecx, ecx

        $sequence_9 = { 8dbd9cfdffff 2bd6 83c7fe 0f1f4000 668b4702 83c702 }
            // n = 6, score = 100
            //   8dbd9cfdffff         | lea                 edi, [ebp - 0x264]
            //   2bd6                 | sub                 edx, esi
            //   83c7fe               | add                 edi, -2
            //   0f1f4000             | nop                 dword ptr [eax]
            //   668b4702             | mov                 ax, word ptr [edi + 2]
            //   83c702               | add                 edi, 2

    condition:
        7 of them and filesize < 196608
}