rule win_cryptbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.cryptbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cryptbot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c0 85ed 0f94c0 8be8 }
            // n = 4, score = 700
            //   33c0                 | xor                 eax, eax
            //   85ed                 | test                ebp, ebp
            //   0f94c0               | sete                al
            //   8be8                 | mov                 ebp, eax

        $sequence_1 = { e9???????? b944dc0000 e9???????? b964dc0000 e9???????? b95ddc0000 e9???????? }
            // n = 7, score = 600
            //   e9????????           |                     
            //   b944dc0000           | mov                 ecx, 0xdc44
            //   e9????????           |                     
            //   b964dc0000           | mov                 ecx, 0xdc64
            //   e9????????           |                     
            //   b95ddc0000           | mov                 ecx, 0xdc5d
            //   e9????????           |                     

        $sequence_2 = { e9???????? b949dc0000 e9???????? b944dc0000 e9???????? }
            // n = 5, score = 600
            //   e9????????           |                     
            //   b949dc0000           | mov                 ecx, 0xdc49
            //   e9????????           |                     
            //   b944dc0000           | mov                 ecx, 0xdc44
            //   e9????????           |                     

        $sequence_3 = { e8???????? 85c0 750f b955960100 e8???????? e9???????? }
            // n = 6, score = 600
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   750f                 | jne                 0x11
            //   b955960100           | mov                 ecx, 0x19655
            //   e8????????           |                     
            //   e9????????           |                     

        $sequence_4 = { 0f9cc0 eb02 32c0 84c0 }
            // n = 4, score = 600
            //   0f9cc0               | setl                al
            //   eb02                 | jmp                 4
            //   32c0                 | xor                 al, al
            //   84c0                 | test                al, al

        $sequence_5 = { eb0c b99fed0000 e8???????? 8907 }
            // n = 4, score = 600
            //   eb0c                 | jmp                 0xe
            //   b99fed0000           | mov                 ecx, 0xed9f
            //   e8????????           |                     
            //   8907                 | mov                 dword ptr [edi], eax

        $sequence_6 = { e8???????? 85c0 750e b9ca070200 e8???????? 8bc8 }
            // n = 6, score = 600
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   750e                 | jne                 0x10
            //   b9ca070200           | mov                 ecx, 0x207ca
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax

        $sequence_7 = { 33c0 eb0a b917d90000 e8???????? }
            // n = 4, score = 600
            //   33c0                 | xor                 eax, eax
            //   eb0a                 | jmp                 0xc
            //   b917d90000           | mov                 ecx, 0xd917
            //   e8????????           |                     

        $sequence_8 = { 1ac9 2403 80e110 8ad1 3c02 7509 }
            // n = 6, score = 400
            //   1ac9                 | sbb                 cl, cl
            //   2403                 | and                 al, 3
            //   80e110               | and                 cl, 0x10
            //   8ad1                 | mov                 dl, cl
            //   3c02                 | cmp                 al, 2
            //   7509                 | jne                 0xb

        $sequence_9 = { 743a 833902 7c35 8b442410 }
            // n = 4, score = 400
            //   743a                 | je                  0x3c
            //   833902               | cmp                 dword ptr [ecx], 2
            //   7c35                 | jl                  0x37
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]

        $sequence_10 = { 7419 8b542408 83fa01 7c10 0fbf4846 3bd1 }
            // n = 6, score = 400
            //   7419                 | je                  0x1b
            //   8b542408             | mov                 edx, dword ptr [esp + 8]
            //   83fa01               | cmp                 edx, 1
            //   7c10                 | jl                  0x12
            //   0fbf4846             | movsx               ecx, word ptr [eax + 0x46]
            //   3bd1                 | cmp                 edx, ecx

        $sequence_11 = { 740d 8bce e8???????? 8b4c2424 8901 }
            // n = 5, score = 400
            //   740d                 | je                  0xf
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8b4c2424             | mov                 ecx, dword ptr [esp + 0x24]
            //   8901                 | mov                 dword ptr [ecx], eax

        $sequence_12 = { 7416 8b4210 83786000 750d }
            // n = 4, score = 400
            //   7416                 | je                  0x18
            //   8b4210               | mov                 eax, dword ptr [edx + 0x10]
            //   83786000             | cmp                 dword ptr [eax + 0x60], 0
            //   750d                 | jne                 0xf

        $sequence_13 = { 744e 0fb74802 83e103 3bcb }
            // n = 4, score = 400
            //   744e                 | je                  0x50
            //   0fb74802             | movzx               ecx, word ptr [eax + 2]
            //   83e103               | and                 ecx, 3
            //   3bcb                 | cmp                 ecx, ebx

        $sequence_14 = { 7422 8b0e b201 e8???????? }
            // n = 4, score = 400
            //   7422                 | je                  0x24
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   b201                 | mov                 dl, 1
            //   e8????????           |                     

        $sequence_15 = { 8b4d0c 8b09 89ce bf00000000 }
            // n = 4, score = 100
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8b09                 | mov                 ecx, dword ptr [ecx]
            //   89ce                 | mov                 esi, ecx
            //   bf00000000           | mov                 edi, 0

        $sequence_16 = { 8b4d08 8b4974 8b09 8901 }
            // n = 4, score = 100
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b4974               | mov                 ecx, dword ptr [ecx + 0x74]
            //   8b09                 | mov                 ecx, dword ptr [ecx]
            //   8901                 | mov                 dword ptr [ecx], eax

        $sequence_17 = { 8b4d0c 8901 895104 c745fc02000000 }
            // n = 4, score = 100
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8901                 | mov                 dword ptr [ecx], eax
            //   895104               | mov                 dword ptr [ecx + 4], edx
            //   c745fc02000000       | mov                 dword ptr [ebp - 4], 2

        $sequence_18 = { 8b4d08 8b9584000000 8b85a0000000 899c249c000000 }
            // n = 4, score = 100
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b9584000000         | mov                 edx, dword ptr [ebp + 0x84]
            //   8b85a0000000         | mov                 eax, dword ptr [ebp + 0xa0]
            //   899c249c000000       | mov                 dword ptr [esp + 0x9c], ebx

        $sequence_19 = { 8b4d0c 898d4cffffff 8b55c8 899548ffffff }
            // n = 4, score = 100
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   898d4cffffff         | mov                 dword ptr [ebp - 0xb4], ecx
            //   8b55c8               | mov                 edx, dword ptr [ebp - 0x38]
            //   899548ffffff         | mov                 dword ptr [ebp - 0xb8], edx

        $sequence_20 = { 8b4d0c 898c249c000000 8b4d10 898c2498000000 }
            // n = 4, score = 100
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   898c249c000000       | mov                 dword ptr [esp + 0x9c], ecx
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   898c2498000000       | mov                 dword ptr [esp + 0x98], ecx

        $sequence_21 = { 8b4d08 8b4978 8b19 89542408 }
            // n = 4, score = 100
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b4978               | mov                 ecx, dword ptr [ecx + 0x78]
            //   8b19                 | mov                 ebx, dword ptr [ecx]
            //   89542408             | mov                 dword ptr [esp + 8], edx

        $sequence_22 = { 8b4d0c 8b09 01f0 11fa }
            // n = 4, score = 100
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8b09                 | mov                 ecx, dword ptr [ecx]
            //   01f0                 | add                 eax, esi
            //   11fa                 | adc                 edx, edi

    condition:
        7 of them and filesize < 17138688
}