rule win_cryptic_convo_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.cryptic_convo."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cryptic_convo"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? ff35???????? ff15???????? 8b06 8bce ff9064010000 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8bce                 | mov                 ecx, esi
            //   ff9064010000         | call                dword ptr [eax + 0x164]

        $sequence_1 = { 8d9ddcfcffff e8???????? 59 59 85c0 0f8406020000 }
            // n = 6, score = 100
            //   8d9ddcfcffff         | lea                 ebx, [ebp - 0x324]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   0f8406020000         | je                  0x20c

        $sequence_2 = { 6a00 50 e8???????? be???????? 8d7dc8 a5 }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     
            //   be????????           |                     
            //   8d7dc8               | lea                 edi, [ebp - 0x38]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]

        $sequence_3 = { c3 8b442404 33d2 f7742408 85d2 7505 8b442404 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   33d2                 | xor                 edx, edx
            //   f7742408             | div                 dword ptr [esp + 8]
            //   85d2                 | test                edx, edx
            //   7505                 | jne                 7
            //   8b442404             | mov                 eax, dword ptr [esp + 4]

        $sequence_4 = { 53 eb25 803d????????01 741b 803d????????01 }
            // n = 5, score = 100
            //   53                   | push                ebx
            //   eb25                 | jmp                 0x27
            //   803d????????01       |                     
            //   741b                 | je                  0x1d
            //   803d????????01       |                     

        $sequence_5 = { 85f6 7508 ff15???????? eb06 ff15???????? }
            // n = 5, score = 100
            //   85f6                 | test                esi, esi
            //   7508                 | jne                 0xa
            //   ff15????????         |                     
            //   eb06                 | jmp                 8
            //   ff15????????         |                     

        $sequence_6 = { 8d85e0fcffff 50 66a5 ffd3 59 59 85c0 }
            // n = 7, score = 100
            //   8d85e0fcffff         | lea                 eax, [ebp - 0x320]
            //   50                   | push                eax
            //   66a5                 | movsw               word ptr es:[edi], word ptr [esi]
            //   ffd3                 | call                ebx
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax

        $sequence_7 = { 8b85ecfcffff 8b95f4fcffff 53 ff7510 89540134 50 }
            // n = 6, score = 100
            //   8b85ecfcffff         | mov                 eax, dword ptr [ebp - 0x314]
            //   8b95f4fcffff         | mov                 edx, dword ptr [ebp - 0x30c]
            //   53                   | push                ebx
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   89540134             | mov                 dword ptr [ecx + eax + 0x34], edx
            //   50                   | push                eax

        $sequence_8 = { 5e e8???????? c9 c3 e8???????? c20400 }
            // n = 6, score = 100
            //   5e                   | pop                 esi
            //   e8????????           |                     
            //   c9                   | leave               
            //   c3                   | ret                 
            //   e8????????           |                     
            //   c20400               | ret                 4

        $sequence_9 = { 75f8 be???????? a5 a5 8d85c0fdffff 50 66a5 }
            // n = 7, score = 100
            //   75f8                 | jne                 0xfffffffa
            //   be????????           |                     
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   8d85c0fdffff         | lea                 eax, [ebp - 0x240]
            //   50                   | push                eax
            //   66a5                 | movsw               word ptr es:[edi], word ptr [esi]

    condition:
        7 of them and filesize < 97280
}