rule win_cryptoshield_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.cryptoshield."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cryptoshield"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bf8 33db eb44 ff75f8 }
            // n = 4, score = 300
            //   8bf8                 | mov                 edi, eax
            //   33db                 | xor                 ebx, ebx
            //   eb44                 | jmp                 0x46
            //   ff75f8               | push                dword ptr [ebp - 8]

        $sequence_1 = { 7419 ff33 ff15???????? 8b4d0c 8b45f0 8901 }
            // n = 6, score = 300
            //   7419                 | je                  0x1b
            //   ff33                 | push                dword ptr [ebx]
            //   ff15????????         |                     
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8901                 | mov                 dword ptr [ecx], eax

        $sequence_2 = { 8b4508 50 8945f0 8d4508 50 57 }
            // n = 6, score = 300
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8d4508               | lea                 eax, [ebp + 8]
            //   50                   | push                eax
            //   57                   | push                edi

        $sequence_3 = { 7405 83fe04 7563 6808020000 8d442424 }
            // n = 5, score = 300
            //   7405                 | je                  7
            //   83fe04               | cmp                 esi, 4
            //   7563                 | jne                 0x65
            //   6808020000           | push                0x208
            //   8d442424             | lea                 eax, [esp + 0x24]

        $sequence_4 = { 56 ff15???????? 6a00 8d85e8fbffff 50 6a01 }
            // n = 6, score = 300
            //   56                   | push                esi
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   8d85e8fbffff         | lea                 eax, [ebp - 0x418]
            //   50                   | push                eax
            //   6a01                 | push                1

        $sequence_5 = { 740e 0fb74802 83c002 6685c9 75ef eb12 66833800 }
            // n = 7, score = 300
            //   740e                 | je                  0x10
            //   0fb74802             | movzx               ecx, word ptr [eax + 2]
            //   83c002               | add                 eax, 2
            //   6685c9               | test                cx, cx
            //   75ef                 | jne                 0xfffffff1
            //   eb12                 | jmp                 0x14
            //   66833800             | cmp                 word ptr [eax], 0

        $sequence_6 = { 8bfa 744d 8d4900 0fb732 }
            // n = 4, score = 300
            //   8bfa                 | mov                 edi, edx
            //   744d                 | je                  0x4f
            //   8d4900               | lea                 ecx, [ecx]
            //   0fb732               | movzx               esi, word ptr [edx]

        $sequence_7 = { ff15???????? 8bf0 83fe03 7413 83fe02 }
            // n = 5, score = 300
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   83fe03               | cmp                 esi, 3
            //   7413                 | je                  0x15
            //   83fe02               | cmp                 esi, 2

        $sequence_8 = { 6685c0 743b 8bf0 8d642400 }
            // n = 4, score = 300
            //   6685c0               | test                ax, ax
            //   743b                 | je                  0x3d
            //   8bf0                 | mov                 esi, eax
            //   8d642400             | lea                 esp, [esp]

        $sequence_9 = { ff33 ffd6 ff75fc ff15???????? ff75f8 }
            // n = 5, score = 300
            //   ff33                 | push                dword ptr [ebx]
            //   ffd6                 | call                esi
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff15????????         |                     
            //   ff75f8               | push                dword ptr [ebp - 8]

    condition:
        7 of them and filesize < 131072
}