rule win_cryptoshuffler_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.cryptoshuffler."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cryptoshuffler"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7777 8bd8 53 e8???????? 83c404 8b7de8 b8abaaaa2a }
            // n = 7, score = 100
            //   7777                 | ja                  0x79
            //   8bd8                 | mov                 ebx, eax
            //   53                   | push                ebx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b7de8               | mov                 edi, dword ptr [ebp - 0x18]
            //   b8abaaaa2a           | mov                 eax, 0x2aaaaaab

        $sequence_1 = { 833e00 7568 6a10 e8???????? 8bf8 83c404 897d08 }
            // n = 7, score = 100
            //   833e00               | cmp                 dword ptr [esi], 0
            //   7568                 | jne                 0x6a
            //   6a10                 | push                0x10
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   83c404               | add                 esp, 4
            //   897d08               | mov                 dword ptr [ebp + 8], edi

        $sequence_2 = { 7ed0 83c8ff eb07 8b04f5740f0210 5f 5e 5b }
            // n = 7, score = 100
            //   7ed0                 | jle                 0xffffffd2
            //   83c8ff               | or                  eax, 0xffffffff
            //   eb07                 | jmp                 9
            //   8b04f5740f0210       | mov                 eax, dword ptr [esi*8 + 0x10020f74]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_3 = { 8500 ebe7 53 8bdc 51 }
            // n = 5, score = 100
            //   8500                 | test                dword ptr [eax], eax
            //   ebe7                 | jmp                 0xffffffe9
            //   53                   | push                ebx
            //   8bdc                 | mov                 ebx, esp
            //   51                   | push                ecx

        $sequence_4 = { e9???????? 8d4e10 51 50 }
            // n = 4, score = 100
            //   e9????????           |                     
            //   8d4e10               | lea                 ecx, [esi + 0x10]
            //   51                   | push                ecx
            //   50                   | push                eax

        $sequence_5 = { 8bf1 e8???????? 8bd0 0f57c0 83c404 8955fc }
            // n = 6, score = 100
            //   8bf1                 | mov                 esi, ecx
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   0f57c0               | xorps               xmm0, xmm0
            //   83c404               | add                 esp, 4
            //   8955fc               | mov                 dword ptr [ebp - 4], edx

        $sequence_6 = { 8bc1 3914c5f84c0210 7408 40 }
            // n = 4, score = 100
            //   8bc1                 | mov                 eax, ecx
            //   3914c5f84c0210       | cmp                 dword ptr [eax*8 + 0x10024cf8], edx
            //   7408                 | je                  0xa
            //   40                   | inc                 eax

        $sequence_7 = { 57 e8???????? 83c404 8933 c6430400 8bc3 8b4df4 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8933                 | mov                 dword ptr [ebx], esi
            //   c6430400             | mov                 byte ptr [ebx + 4], 0
            //   8bc3                 | mov                 eax, ebx
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

        $sequence_8 = { e8???????? 85c0 0f8550feffff 5f 5e 5b 8b4c2428 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8550feffff         | jne                 0xfffffe56
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   8b4c2428             | mov                 ecx, dword ptr [esp + 0x28]

        $sequence_9 = { 0f82a5040000 8b4c2410 40 3d00100000 722a f6c11f 0f8562050000 }
            // n = 7, score = 100
            //   0f82a5040000         | jb                  0x4ab
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   40                   | inc                 eax
            //   3d00100000           | cmp                 eax, 0x1000
            //   722a                 | jb                  0x2c
            //   f6c11f               | test                cl, 0x1f
            //   0f8562050000         | jne                 0x568

    condition:
        7 of them and filesize < 425984
}