rule win_cryptxxxx_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cryptxxxx"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff5014 6a0f 8b45f8 50 8b00 ff500c 33c0 }
            // n = 7, score = 900
            //   ff5014               | call                dword ptr [eax + 0x14]
            //   6a0f                 | push                0xf
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   50                   | push                eax
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   ff500c               | call                dword ptr [eax + 0xc]
            //   33c0                 | xor                 eax, eax

        $sequence_1 = { c645f701 eb0e c645f700 33c0 5a }
            // n = 5, score = 900
            //   c645f701             | mov                 byte ptr [ebp - 9], 1
            //   eb0e                 | jmp                 0x10
            //   c645f700             | mov                 byte ptr [ebp - 9], 0
            //   33c0                 | xor                 eax, eax
            //   5a                   | pop                 edx

        $sequence_2 = { 648910 eb35 33c0 5a }
            // n = 4, score = 900
            //   648910               | mov                 dword ptr fs:[eax], edx
            //   eb35                 | jmp                 0x37
            //   33c0                 | xor                 eax, eax
            //   5a                   | pop                 edx

        $sequence_3 = { 648910 ebd4 e9???????? e8???????? }
            // n = 4, score = 900
            //   648910               | mov                 dword ptr fs:[eax], edx
            //   ebd4                 | jmp                 0xffffffd6
            //   e9????????           |                     
            //   e8????????           |                     

        $sequence_4 = { 8945f4 6a00 8d45f0 50 8b45f8 }
            // n = 5, score = 900
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   6a00                 | push                0
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_5 = { 50 8b45f8 50 8b00 ff5014 6a0f }
            // n = 6, score = 900
            //   50                   | push                eax
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   50                   | push                eax
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   ff5014               | call                dword ptr [eax + 0x14]
            //   6a0f                 | push                0xf

        $sequence_6 = { 8955f8 8945fc c645f700 33c0 55 }
            // n = 5, score = 900
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   c645f700             | mov                 byte ptr [ebp - 9], 0
            //   33c0                 | xor                 eax, eax
            //   55                   | push                ebp

        $sequence_7 = { 6a00 e8???????? b800040000 e8???????? }
            // n = 4, score = 900
            //   6a00                 | push                0
            //   e8????????           |                     
            //   b800040000           | mov                 eax, 0x400
            //   e8????????           |                     

        $sequence_8 = { 59 648910 ebd4 e9???????? e8???????? }
            // n = 5, score = 900
            //   59                   | pop                 ecx
            //   648910               | mov                 dword ptr fs:[eax], edx
            //   ebd4                 | jmp                 0xffffffd6
            //   e9????????           |                     
            //   e8????????           |                     

        $sequence_9 = { 648910 ebd4 e9???????? e8???????? ebc8 33c0 5a }
            // n = 7, score = 900
            //   648910               | mov                 dword ptr fs:[eax], edx
            //   ebd4                 | jmp                 0xffffffd6
            //   e9????????           |                     
            //   e8????????           |                     
            //   ebc8                 | jmp                 0xffffffca
            //   33c0                 | xor                 eax, eax
            //   5a                   | pop                 edx

    condition:
        7 of them and filesize < 745472
}