rule win_crytox_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.crytox."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.crytox"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 85c0 0f8483000000 c744240402a00000 891c24 e8???????? 895c2430 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   85c0                 | test                al, al
            //   0f8483000000         | je                  0xafd
            //   c744240402a00000     | cmp                 ebx, 0x668ae0
            //   891c24               | jne                 0xb32
            //   e8????????           |                     
            //   895c2430             | jmp                 0xb2d

        $sequence_1 = { c1ff1f 31f8 29f8 8d3402 0fb601 0fb613 29c2 }
            // n = 7, score = 100
            //   c1ff1f               | mov                 edx, edi
            //   31f8                 | movzx               edi, di
            //   29f8                 | sar                 edi, 0x10
            //   8d3402               | add                 eax, edi
            //   0fb601               | mov                 edi, dword ptr [ebp - 0x64]
            //   0fb613               | add                 eax, edx
            //   29c2                 | mov                 edx, dword ptr [ecx - 0x10]

        $sequence_2 = { d90481 8b442460 c744240801000000 d9ee 890424 dfe9 ddd8 }
            // n = 7, score = 100
            //   d90481               | fld                 dword ptr [ebp + eax*4]
            //   8b442460             | fmul                dword ptr [ebx + eax*4 + 4]
            //   c744240801000000     | add                 eax, 1
            //   d9ee                 | fld                 dword ptr [ebx]
            //   890424               | jle                 0x156
            //   dfe9                 | xor                 eax, eax
            //   ddd8                 | nop                 

        $sequence_3 = { f7d0 31f6 c1e206 01d0 80bd7ffeffff00 7419 8bb5f8feffff }
            // n = 7, score = 100
            //   f7d0                 | mul                 dword ptr [esp + 0x90]
            //   31f6                 | add                 eax, ebx
            //   c1e206               | mov                 ebx, dword ptr [esp + 0x88]
            //   01d0                 | adc                 edx, esi
            //   80bd7ffeffff00       | mov                 esi, eax
            //   7419                 | mov                 eax, dword ptr [esp + 0x14]
            //   8bb5f8feffff         | mov                 edi, edx

        $sequence_4 = { e8???????? 8b4c2440 3c3f 880419 76e4 8b15???????? c644242c01 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b4c2440             | mov                 dword ptr [esp], eax
            //   3c3f                 | mov                 eax, dword ptr [ebp - 0x10]
            //   880419               | mov                 eax, dword ptr [ebp - 0x10]
            //   76e4                 | lea                 edx, [eax*4]
            //   8b15????????         |                     
            //   c644242c01           | mov                 eax, dword ptr [ebp + 8]

        $sequence_5 = { c5fd7f9c2440060000 c5fd7fac24a0050000 c5c5fe9c2460050000 c5c5feec c5fd7f9c2480050000 c5c5fe942400050000 c5c5fea42440070000 }
            // n = 7, score = 100
            //   c5fd7f9c2440060000     | vmovdqa    ymmword ptr [esp + 0xd00], ymm3
            //   c5fd7fac24a0050000     | vmovdqa    ymm3, ymmword ptr [esp + 0xc80]
            //   c5c5fe9c2460050000     | vpsrad    ymm3, ymm3, 0xe
            //   c5c5feec             | vmovdqa             ymmword ptr [esp + 0xce0], ymm3
            //   c5fd7f9c2480050000     | vmovdqa    ymmword ptr [esp + 0x1220], ymm3
            //   c5c5fe942400050000     | vmovdqa    ymmword ptr [esp + 0x1060], ymm6
            //   c5c5fea42440070000     | vmovdqa    ymm6, ymmword ptr [esp + 0xcc0]

        $sequence_6 = { e8???????? 0fb68520faffff 8844242c 83e07f 3c02 0f84c9020000 8b8528faffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   0fb68520faffff       | add                 esp, 0x2c
            //   8844242c             | pop                 ebx
            //   83e07f               | pop                 esi
            //   3c02                 | add                 ebx, dword ptr [ebp + 8]
            //   0f84c9020000         | test                eax, eax
            //   8b8528faffff         | je                  0x170

        $sequence_7 = { e9???????? 0fb68fe06f6900 89d8 29c8 d3e7 d3e2 89854c3d0000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   0fb68fe06f6900       | mov                 dword ptr [esp], edi
            //   89d8                 | mov                 dword ptr [esp + 4], 0xa003
            //   29c8                 | mov                 dword ptr [esp + 0x40], edi
            //   d3e7                 | add                 esp, 0x2c
            //   d3e2                 | jmp                 0x1e5
            //   89854c3d0000         | mov                 eax, dword ptr [ebx + 4]

        $sequence_8 = { d905???????? d94508 d9c9 dfe9 ddd8 7207 b80080ffff }
            // n = 7, score = 100
            //   d905????????         |                     
            //   d94508               | mov                 dword ptr [esi + ebp*4], eax
            //   d9c9                 | add                 ebp, 1
            //   dfe9                 | cmp                 ebx, ebp
            //   ddd8                 | fmul                dword ptr [eax + esi*4]
            //   7207                 | fxch                st(1)
            //   b80080ffff           | fucomi              st(1)

        $sequence_9 = { e9???????? 8b4508 8b4044 8b55c8 c1e202 01d0 8b00 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b4508               | mov                 dword ptr [esp + 0x14], edx
            //   8b4044               | mov                 edx, dword ptr [esp + 0x14]
            //   8b55c8               | mov                 eax, dword ptr [ebx + 0x14]
            //   c1e202               | mov                 dword ptr [esp], eax
            //   01d0                 | mov                 edi, dword ptr [ebx + 0x38]
            //   8b00                 | test                edi, edi

    condition:
        7 of them and filesize < 6156288
}