rule win_darkmoon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.darkmoon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.darkmoon"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6802000080 ff5645 8d45fc 50 }
            // n = 4, score = 100
            //   6802000080           | push                0x80000002
            //   ff5645               | call                dword ptr [esi + 0x45]
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax

        $sequence_1 = { 50 ff5679 6a00 8d8514faffff }
            // n = 4, score = 100
            //   50                   | push                eax
            //   ff5679               | call                dword ptr [esi + 0x79]
            //   6a00                 | push                0
            //   8d8514faffff         | lea                 eax, [ebp - 0x5ec]

        $sequence_2 = { 0f843cffffff 33c0 6a00 c1e009 6a00 }
            // n = 5, score = 100
            //   0f843cffffff         | je                  0xffffff42
            //   33c0                 | xor                 eax, eax
            //   6a00                 | push                0
            //   c1e009               | shl                 eax, 9
            //   6a00                 | push                0

        $sequence_3 = { 51 50 50 8d860f040000 }
            // n = 4, score = 100
            //   51                   | push                ecx
            //   50                   | push                eax
            //   50                   | push                eax
            //   8d860f040000         | lea                 eax, [esi + 0x40f]

        $sequence_4 = { 6a00 6800000080 8d86b1060000 50 ff5659 50 6888b6b6fc }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   6800000080           | push                0x80000000
            //   8d86b1060000         | lea                 eax, [esi + 0x6b1]
            //   50                   | push                eax
            //   ff5659               | call                dword ptr [esi + 0x59]
            //   50                   | push                eax
            //   6888b6b6fc           | push                0xfcb6b688

        $sequence_5 = { 33d2 8dbe48010000 6834284050 8903 6800080000 56 894b04 }
            // n = 7, score = 100
            //   33d2                 | xor                 edx, edx
            //   8dbe48010000         | lea                 edi, [esi + 0x148]
            //   6834284050           | push                0x50402834
            //   8903                 | mov                 dword ptr [ebx], eax
            //   6800080000           | push                0x800
            //   56                   | push                esi
            //   894b04               | mov                 dword ptr [ebx + 4], ecx

        $sequence_6 = { 8d44241c 52 8b542414 8d4c2418 50 }
            // n = 5, score = 100
            //   8d44241c             | lea                 eax, [esp + 0x1c]
            //   52                   | push                edx
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]
            //   8d4c2418             | lea                 ecx, [esp + 0x18]
            //   50                   | push                eax

        $sequence_7 = { 8d4f0c 52 e8???????? 8d44240c }
            // n = 4, score = 100
            //   8d4f0c               | lea                 ecx, [edi + 0xc]
            //   52                   | push                edx
            //   e8????????           |                     
            //   8d44240c             | lea                 eax, [esp + 0xc]

        $sequence_8 = { ff96d1000000 5a 59 8901 59 03d1 ebd3 }
            // n = 7, score = 100
            //   ff96d1000000         | call                dword ptr [esi + 0xd1]
            //   5a                   | pop                 edx
            //   59                   | pop                 ecx
            //   8901                 | mov                 dword ptr [ecx], eax
            //   59                   | pop                 ecx
            //   03d1                 | add                 edx, ecx
            //   ebd3                 | jmp                 0xffffffd5

        $sequence_9 = { 8d86120e0000 8945cc 8d45dc 50 6a01 }
            // n = 5, score = 100
            //   8d86120e0000         | lea                 eax, [esi + 0xe12]
            //   8945cc               | mov                 dword ptr [ebp - 0x34], eax
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   50                   | push                eax
            //   6a01                 | push                1

    condition:
        7 of them and filesize < 98304
}