rule win_darkside_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.darkside."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.darkside"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 59 5b 5d c20c00 55 }
            // n = 5, score = 1100
            //   59                   | pop                 ecx
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c20c00               | ret                 0xc
            //   55                   | push                ebp

        $sequence_1 = { 81c7ff000000 4b 85db 75ea 85d2 7407 }
            // n = 6, score = 1100
            //   81c7ff000000         | add                 edi, 0xff
            //   4b                   | dec                 ebx
            //   85db                 | test                ebx, ebx
            //   75ea                 | jne                 0xffffffec
            //   85d2                 | test                edx, edx
            //   7407                 | je                  9

        $sequence_2 = { 7306 fec1 75da eb06 33db fec1 }
            // n = 6, score = 1100
            //   7306                 | jae                 8
            //   fec1                 | inc                 cl
            //   75da                 | jne                 0xffffffdc
            //   eb06                 | jmp                 8
            //   33db                 | xor                 ebx, ebx
            //   fec1                 | inc                 cl

        $sequence_3 = { 57 b9f0000000 be???????? 8b4508 }
            // n = 4, score = 1100
            //   57                   | push                edi
            //   b9f0000000           | mov                 ecx, 0xf0
            //   be????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_4 = { 81eb10101010 81ef10101010 83e910 79d5 33d2 33c9 8b750c }
            // n = 7, score = 1100
            //   81eb10101010         | sub                 ebx, 0x10101010
            //   81ef10101010         | sub                 edi, 0x10101010
            //   83e910               | sub                 ecx, 0x10
            //   79d5                 | jns                 0xffffffd7
            //   33d2                 | xor                 edx, edx
            //   33c9                 | xor                 ecx, ecx
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]

        $sequence_5 = { 59 5b 5d c20800 55 8bec 53 }
            // n = 7, score = 1100
            //   59                   | pop                 ecx
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c20800               | ret                 8
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   53                   | push                ebx

        $sequence_6 = { 83e910 79d5 33d2 33c9 8b750c 33db }
            // n = 6, score = 1100
            //   83e910               | sub                 ecx, 0x10
            //   79d5                 | jns                 0xffffffd7
            //   33d2                 | xor                 edx, edx
            //   33c9                 | xor                 ecx, ecx
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]
            //   33db                 | xor                 ebx, ebx

        $sequence_7 = { 4b 85db 75ea 85d2 7407 }
            // n = 5, score = 1100
            //   4b                   | dec                 ebx
            //   85db                 | test                ebx, ebx
            //   75ea                 | jne                 0xffffffec
            //   85d2                 | test                edx, edx
            //   7407                 | je                  9

        $sequence_8 = { 83e910 79d5 33d2 33c9 8b750c }
            // n = 5, score = 1100
            //   83e910               | sub                 ecx, 0x10
            //   79d5                 | jns                 0xffffffd7
            //   33d2                 | xor                 edx, edx
            //   33c9                 | xor                 ecx, ecx
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]

        $sequence_9 = { 893c0e 81ea10101010 2d10101010 81eb10101010 81ef10101010 83e910 }
            // n = 6, score = 1100
            //   893c0e               | mov                 dword ptr [esi + ecx], edi
            //   81ea10101010         | sub                 edx, 0x10101010
            //   2d10101010           | sub                 eax, 0x10101010
            //   81eb10101010         | sub                 ebx, 0x10101010
            //   81ef10101010         | sub                 edi, 0x10101010
            //   83e910               | sub                 ecx, 0x10

    condition:
        7 of them and filesize < 286720
}