rule win_darktrack_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.darktrack_rat"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8d8dc4f7ffff 8d85dcf7ffff 8bd7 e8???????? 8b95c4f7ffff }
            // n = 6, score = 300
            //   e8????????           |                     
            //   8d8dc4f7ffff         | lea                 ecx, [ebp - 0x83c]
            //   8d85dcf7ffff         | lea                 eax, [ebp - 0x824]
            //   8bd7                 | mov                 edx, edi
            //   e8????????           |                     
            //   8b95c4f7ffff         | mov                 edx, dword ptr [ebp - 0x83c]

        $sequence_1 = { b211 8b8544feffff e8???????? e9???????? 8b45f0 e8???????? e8???????? }
            // n = 7, score = 300
            //   b211                 | mov                 dl, 0x11
            //   8b8544feffff         | mov                 eax, dword ptr [ebp - 0x1bc]
            //   e8????????           |                     
            //   e9????????           |                     
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   e8????????           |                     
            //   e8????????           |                     

        $sequence_2 = { a1???????? 50 e8???????? 85c0 0f845e030000 50 a1???????? }
            // n = 7, score = 300
            //   a1????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f845e030000         | je                  0x364
            //   50                   | push                eax
            //   a1????????           |                     

        $sequence_3 = { 8bde 85db 75b3 8b5f08 4b 85db }
            // n = 6, score = 300
            //   8bde                 | mov                 ebx, esi
            //   85db                 | test                ebx, ebx
            //   75b3                 | jne                 0xffffffb5
            //   8b5f08               | mov                 ebx, dword ptr [edi + 8]
            //   4b                   | dec                 ebx
            //   85db                 | test                ebx, ebx

        $sequence_4 = { 50 68???????? 8d85c4fbffff 8d95e6fbffff b909020000 e8???????? ffb5c4fbffff }
            // n = 7, score = 300
            //   50                   | push                eax
            //   68????????           |                     
            //   8d85c4fbffff         | lea                 eax, [ebp - 0x43c]
            //   8d95e6fbffff         | lea                 edx, [ebp - 0x41a]
            //   b909020000           | mov                 ecx, 0x209
            //   e8????????           |                     
            //   ffb5c4fbffff         | push                dword ptr [ebp - 0x43c]

        $sequence_5 = { 55 8bec 83c4c8 53 56 33c0 8945fc }
            // n = 7, score = 300
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83c4c8               | add                 esp, -0x38
            //   53                   | push                ebx
            //   56                   | push                esi
            //   33c0                 | xor                 eax, eax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_6 = { 84c0 0f844c050000 8d85a0feffff b9???????? 8b13 e8???????? 8b85a0feffff }
            // n = 7, score = 300
            //   84c0                 | test                al, al
            //   0f844c050000         | je                  0x552
            //   8d85a0feffff         | lea                 eax, [ebp - 0x160]
            //   b9????????           |                     
            //   8b13                 | mov                 edx, dword ptr [ebx]
            //   e8????????           |                     
            //   8b85a0feffff         | mov                 eax, dword ptr [ebp - 0x160]

        $sequence_7 = { 8d1485ee5d4900 89542454 813c241f010000 7f1f 8b4c2454 66c7010800 ff0424 }
            // n = 7, score = 300
            //   8d1485ee5d4900       | lea                 edx, [eax*4 + 0x495dee]
            //   89542454             | mov                 dword ptr [esp + 0x54], edx
            //   813c241f010000       | cmp                 dword ptr [esp], 0x11f
            //   7f1f                 | jg                  0x21
            //   8b4c2454             | mov                 ecx, dword ptr [esp + 0x54]
            //   66c7010800           | mov                 word ptr [ecx], 8
            //   ff0424               | inc                 dword ptr [esp]

        $sequence_8 = { ba03000000 e8???????? ff33 ba???????? 8bc6 e8???????? 8bd0 }
            // n = 7, score = 300
            //   ba03000000           | mov                 edx, 3
            //   e8????????           |                     
            //   ff33                 | push                dword ptr [ebx]
            //   ba????????           |                     
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax

        $sequence_9 = { 8b4c240c 66d3e7 8b442410 8b048514274600 8b542418 66893c42 eb56 }
            // n = 7, score = 300
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]
            //   66d3e7               | shl                 di, cl
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   8b048514274600       | mov                 eax, dword ptr [eax*4 + 0x462714]
            //   8b542418             | mov                 edx, dword ptr [esp + 0x18]
            //   66893c42             | mov                 word ptr [edx + eax*2], di
            //   eb56                 | jmp                 0x58

    condition:
        7 of them and filesize < 1351680
}