rule win_darkvnc_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.darkvnc."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.darkvnc"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b442404 488b4c2420 0fb70441 83f825 752f 8b0424 b925000000 }
            // n = 7, score = 100
            //   8b442404             | lea                 eax, [esi + 1]
            //   488b4c2420           | mov                 dword ptr [ebp - 0x49], edx
            //   0fb70441             | mov                 dword ptr [ebp - 0x45], ecx
            //   83f825               | test                edx, edx
            //   752f                 | je                  0x1daf
            //   8b0424               | mov                 edx, 4
            //   b925000000           | dec                 eax

        $sequence_1 = { 48894130 8b4108 2b01 894138 7456 488b4328 }
            // n = 6, score = 100
            //   48894130             | mov                 esi, eax
            //   8b4108               | dec                 eax
            //   2b01                 | test                eax, eax
            //   894138               | je                  0x3dc
            //   7456                 | dec                 ebp
            //   488b4328             | add                 eax, eax

        $sequence_2 = { 488b442478 4839842480000000 7417 4c8b842480000000 33d2 488b0d???????? ff15???????? }
            // n = 7, score = 100
            //   488b442478           | mov                 esi, eax
            //   4839842480000000     | dec                 eax
            //   7417                 | test                eax, eax
            //   4c8b842480000000     | je                  0xe24
            //   33d2                 | dec                 eax
            //   488b0d????????       |                     
            //   ff15????????         |                     

        $sequence_3 = { 7406 ff15???????? 85db 7408 8bcb ff15???????? 488bc6 }
            // n = 7, score = 100
            //   7406                 | lea                 ebx, [esp + 0x90]
            //   ff15????????         |                     
            //   85db                 | dec                 ecx
            //   7408                 | mov                 ebx, dword ptr [ebx + 0x20]
            //   8bcb                 | je                  0xf91
            //   ff15????????         |                     
            //   488bc6               | dec                 ecx

        $sequence_4 = { 498bf6 3b6efc 754a f70600000040 7430 e8???????? 83f805 }
            // n = 7, score = 100
            //   498bf6               | sar                 eax, 1
            //   3b6efc               | imul                eax, ebx
            //   754a                 | dec                 eax
            //   f70600000040         | cwde                
            //   7430                 | dec                 esp
            //   e8????????           |                     
            //   83f805               | mov                 edi, dword ptr [esp + 0xb0]

        $sequence_5 = { 85db 755d 488b4df0 ff15???????? 8b4540 448bce 4c8b4530 }
            // n = 7, score = 100
            //   85db                 | dec                 eax
            //   755d                 | mov                 edx, edi
            //   488b4df0             | dec                 eax
            //   ff15????????         |                     
            //   8b4540               | mov                 ecx, esi
            //   448bce               | mov                 ebx, eax
            //   4c8b4530             | test                eax, eax

        $sequence_6 = { 3bc7 74c3 488bcb e8???????? 85b3f0000000 754d ff15???????? }
            // n = 7, score = 100
            //   3bc7                 | mov                 dword ptr [esp + 0x58], 0
            //   74c3                 | dec                 eax
            //   488bcb               | mov                 dword ptr [esp + 0x30], 0
            //   e8????????           |                     
            //   85b3f0000000         | dec                 eax
            //   754d                 | sub                 esp, 0x90
            //   ff15????????         |                     

        $sequence_7 = { 4585db 0f8e86000000 4c63742458 4963e8 498d041e 4c8be9 }
            // n = 6, score = 100
            //   4585db               | jb                  0x1613
            //   0f8e86000000         | inc                 eax
            //   4c63742458           | test                dh, dh
            //   4963e8               | je                  0x1664
            //   498d041e             | inc                 eax
            //   4c8be9               | movzx               eax, dh

        $sequence_8 = { 750c 488b442438 4889442440 eb47 eb24 488b442428 488b00 }
            // n = 7, score = 100
            //   750c                 | lea                 eax, [esp + 0x38]
            //   488b442438           | dec                 eax
            //   4889442440           | mov                 dword ptr [esp + 0x20], eax
            //   eb47                 | inc                 ecx
            //   eb24                 | mov                 ecx, 0x1000
            //   488b442428           | dec                 esp
            //   488b00               | mov                 eax, dword ptr [esp + 0x30]

        $sequence_9 = { 4883c020 4889442430 488b442430 83780400 0f849f000000 488b542440 488b442430 }
            // n = 7, score = 100
            //   4883c020             | mov                 dword ptr [eax + 8], ecx
            //   4889442430           | mov                 dword ptr [esp + 0x20], 1
            //   488b442430           | jmp                 0x1b7
            //   83780400             | dec                 eax
            //   0f849f000000         | mov                 dword ptr [esp + 0x28], 0
            //   488b542440           | dec                 eax
            //   488b442430           | mov                 eax, dword ptr [esp + 0x38]

    condition:
        7 of them and filesize < 606208
}