rule win_ddkeylogger_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ddkeylogger."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ddkeylogger"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 53 56 57 c745f8deb10000 c745fcae3c0000 }
            // n = 5, score = 200
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   c745f8deb10000       | mov                 dword ptr [ebp - 8], 0xb1de
            //   c745fcae3c0000       | mov                 dword ptr [ebp - 4], 0x3cae

        $sequence_1 = { 8bc3 c1f805 8d3c8580ee4500 8bf3 }
            // n = 4, score = 200
            //   8bc3                 | mov                 eax, ebx
            //   c1f805               | sar                 eax, 5
            //   8d3c8580ee4500       | lea                 edi, [eax*4 + 0x45ee80]
            //   8bf3                 | mov                 esi, ebx

        $sequence_2 = { 85c0 752f 6804010000 8d85f8feffff }
            // n = 4, score = 200
            //   85c0                 | test                eax, eax
            //   752f                 | jne                 0x31
            //   6804010000           | push                0x104
            //   8d85f8feffff         | lea                 eax, [ebp - 0x108]

        $sequence_3 = { 7505 3b45fc 72bf 8a18 3a19 7501 40 }
            // n = 7, score = 200
            //   7505                 | jne                 7
            //   3b45fc               | cmp                 eax, dword ptr [ebp - 4]
            //   72bf                 | jb                  0xffffffc1
            //   8a18                 | mov                 bl, byte ptr [eax]
            //   3a19                 | cmp                 bl, byte ptr [ecx]
            //   7501                 | jne                 3
            //   40                   | inc                 eax

        $sequence_4 = { 6a00 6a00 56 8bf8 e8???????? 83c42c 57 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   56                   | push                esi
            //   8bf8                 | mov                 edi, eax
            //   e8????????           |                     
            //   83c42c               | add                 esp, 0x2c
            //   57                   | push                edi

        $sequence_5 = { 8d9b00000000 8a08 40 84c9 75f9 8dbde8faffff 2bc6 }
            // n = 7, score = 200
            //   8d9b00000000         | lea                 ebx, [ebx]
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   40                   | inc                 eax
            //   84c9                 | test                cl, cl
            //   75f9                 | jne                 0xfffffffb
            //   8dbde8faffff         | lea                 edi, [ebp - 0x518]
            //   2bc6                 | sub                 eax, esi

        $sequence_6 = { 56 ff15???????? 8bb5d8faffff 019ddcfaffff 6806030000 8d8de8faffff 6a00 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8bb5d8faffff         | mov                 esi, dword ptr [ebp - 0x528]
            //   019ddcfaffff         | add                 dword ptr [ebp - 0x524], ebx
            //   6806030000           | push                0x306
            //   8d8de8faffff         | lea                 ecx, [ebp - 0x518]
            //   6a00                 | push                0

        $sequence_7 = { e8???????? 8d95b8faffff 52 52 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   8d95b8faffff         | lea                 edx, [ebp - 0x548]
            //   52                   | push                edx
            //   52                   | push                edx

        $sequence_8 = { 8bc7 2bc1 0fb65901 881c08 0fb619 }
            // n = 5, score = 200
            //   8bc7                 | mov                 eax, edi
            //   2bc1                 | sub                 eax, ecx
            //   0fb65901             | movzx               ebx, byte ptr [ecx + 1]
            //   881c08               | mov                 byte ptr [eax + ecx], bl
            //   0fb619               | movzx               ebx, byte ptr [ecx]

        $sequence_9 = { c1eb06 03de 0fb61493 885102 0fb65002 83e23f 0fb61432 }
            // n = 7, score = 200
            //   c1eb06               | shr                 ebx, 6
            //   03de                 | add                 ebx, esi
            //   0fb61493             | movzx               edx, byte ptr [ebx + edx*4]
            //   885102               | mov                 byte ptr [ecx + 2], dl
            //   0fb65002             | movzx               edx, byte ptr [eax + 2]
            //   83e23f               | and                 edx, 0x3f
            //   0fb61432             | movzx               edx, byte ptr [edx + esi]

    condition:
        7 of them and filesize < 808960
}