rule win_ddkong_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ddkong."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ddkong"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 ffd7 ff750c 8bf0 66c745dc0200 ff55fc }
            // n = 6, score = 100
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   8bf0                 | mov                 esi, eax
            //   66c745dc0200         | mov                 word ptr [ebp - 0x24], 2
            //   ff55fc               | call                dword ptr [ebp - 4]

        $sequence_1 = { 8d45f0 50 c645c44d c645c56f c645c676 c645c765 c645c846 }
            // n = 7, score = 100
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   c645c44d             | mov                 byte ptr [ebp - 0x3c], 0x4d
            //   c645c56f             | mov                 byte ptr [ebp - 0x3b], 0x6f
            //   c645c676             | mov                 byte ptr [ebp - 0x3a], 0x76
            //   c645c765             | mov                 byte ptr [ebp - 0x39], 0x65
            //   c645c846             | mov                 byte ptr [ebp - 0x38], 0x46

        $sequence_2 = { 8b4c3878 85c9 8b44387c 894c2410 745a 85c0 }
            // n = 6, score = 100
            //   8b4c3878             | mov                 ecx, dword ptr [eax + edi + 0x78]
            //   85c9                 | test                ecx, ecx
            //   8b44387c             | mov                 eax, dword ptr [eax + edi + 0x7c]
            //   894c2410             | mov                 dword ptr [esp + 0x10], ecx
            //   745a                 | je                  0x5c
            //   85c0                 | test                eax, eax

        $sequence_3 = { c645b963 c645ba75 c645bb72 c645bc69 }
            // n = 4, score = 100
            //   c645b963             | mov                 byte ptr [ebp - 0x47], 0x63
            //   c645ba75             | mov                 byte ptr [ebp - 0x46], 0x75
            //   c645bb72             | mov                 byte ptr [ebp - 0x45], 0x72
            //   c645bc69             | mov                 byte ptr [ebp - 0x44], 0x69

        $sequence_4 = { 53 6a03 e8???????? 83c40c 6a0a }
            // n = 5, score = 100
            //   53                   | push                ebx
            //   6a03                 | push                3
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   6a0a                 | push                0xa

        $sequence_5 = { c685d1feffff75 c685d2feffff70 c685d3feffff6c c685d4feffff69 c685d5feffff63 c685d6feffff61 }
            // n = 6, score = 100
            //   c685d1feffff75       | mov                 byte ptr [ebp - 0x12f], 0x75
            //   c685d2feffff70       | mov                 byte ptr [ebp - 0x12e], 0x70
            //   c685d3feffff6c       | mov                 byte ptr [ebp - 0x12d], 0x6c
            //   c685d4feffff69       | mov                 byte ptr [ebp - 0x12c], 0x69
            //   c685d5feffff63       | mov                 byte ptr [ebp - 0x12b], 0x63
            //   c685d6feffff61       | mov                 byte ptr [ebp - 0x12a], 0x61

        $sequence_6 = { ab 33c9 33c0 8d7dc4 894dc0 }
            // n = 5, score = 100
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   33c9                 | xor                 ecx, ecx
            //   33c0                 | xor                 eax, eax
            //   8d7dc4               | lea                 edi, [ebp - 0x3c]
            //   894dc0               | mov                 dword ptr [ebp - 0x40], ecx

        $sequence_7 = { 53 ff55f8 53 ff55f4 6a01 ff7508 e8???????? }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   ff55f8               | call                dword ptr [ebp - 8]
            //   53                   | push                ebx
            //   ff55f4               | call                dword ptr [ebp - 0xc]
            //   6a01                 | push                1
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     

        $sequence_8 = { c645d146 c645d269 c645d36c c645d465 c645d54e c645d661 c645d76d }
            // n = 7, score = 100
            //   c645d146             | mov                 byte ptr [ebp - 0x2f], 0x46
            //   c645d269             | mov                 byte ptr [ebp - 0x2e], 0x69
            //   c645d36c             | mov                 byte ptr [ebp - 0x2d], 0x6c
            //   c645d465             | mov                 byte ptr [ebp - 0x2c], 0x65
            //   c645d54e             | mov                 byte ptr [ebp - 0x2b], 0x4e
            //   c645d661             | mov                 byte ptr [ebp - 0x2a], 0x61
            //   c645d76d             | mov                 byte ptr [ebp - 0x29], 0x6d

        $sequence_9 = { 72f6 ff7604 57 ff742418 e8???????? 83c40c 395e1c }
            // n = 7, score = 100
            //   72f6                 | jb                  0xfffffff8
            //   ff7604               | push                dword ptr [esi + 4]
            //   57                   | push                edi
            //   ff742418             | push                dword ptr [esp + 0x18]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   395e1c               | cmp                 dword ptr [esi + 0x1c], ebx

    condition:
        7 of them and filesize < 81920
}