rule win_deltas_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.deltas."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.deltas"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd3 8b442420 85c0 7507 c6851045000001 }
            // n = 5, score = 200
            //   ffd3                 | call                ebx
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9
            //   c6851045000001       | mov                 byte ptr [ebp + 0x4510], 1

        $sequence_1 = { 03f3 8b5604 8b06 85c0 }
            // n = 4, score = 200
            //   03f3                 | add                 esi, ebx
            //   8b5604               | mov                 edx, dword ptr [esi + 4]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   85c0                 | test                eax, eax

        $sequence_2 = { 55 ff15???????? 83fbff 7407 53 ff15???????? 8b442410 }
            // n = 7, score = 200
            //   55                   | push                ebp
            //   ff15????????         |                     
            //   83fbff               | cmp                 ebx, -1
            //   7407                 | je                  9
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]

        $sequence_3 = { 0bc2 33c1 03c5 8b6c2424 8db430e0e62cfe 8bc6 c1e816 }
            // n = 7, score = 200
            //   0bc2                 | or                  eax, edx
            //   33c1                 | xor                 eax, ecx
            //   03c5                 | add                 eax, ebp
            //   8b6c2424             | mov                 ebp, dword ptr [esp + 0x24]
            //   8db430e0e62cfe       | lea                 esi, [eax + esi - 0x1d31920]
            //   8bc6                 | mov                 eax, esi
            //   c1e816               | shr                 eax, 0x16

        $sequence_4 = { 85ed 7407 55 ff15???????? 83fbff 7407 }
            // n = 6, score = 200
            //   85ed                 | test                ebp, ebp
            //   7407                 | je                  9
            //   55                   | push                ebp
            //   ff15????????         |                     
            //   83fbff               | cmp                 ebx, -1
            //   7407                 | je                  9

        $sequence_5 = { 8bc7 f7d0 03d1 0bc2 33c1 03442428 8d843097ff2a43 }
            // n = 7, score = 200
            //   8bc7                 | mov                 eax, edi
            //   f7d0                 | not                 eax
            //   03d1                 | add                 edx, ecx
            //   0bc2                 | or                  eax, edx
            //   33c1                 | xor                 eax, ecx
            //   03442428             | add                 eax, dword ptr [esp + 0x28]
            //   8d843097ff2a43       | lea                 eax, [eax + esi + 0x432aff97]

        $sequence_6 = { 88442461 88442462 8b35???????? 8d442470 }
            // n = 4, score = 200
            //   88442461             | mov                 byte ptr [esp + 0x61], al
            //   88442462             | mov                 byte ptr [esp + 0x62], al
            //   8b35????????         |                     
            //   8d442470             | lea                 eax, [esp + 0x70]

        $sequence_7 = { 8b5604 89542448 8d542428 8b4608 }
            // n = 4, score = 200
            //   8b5604               | mov                 edx, dword ptr [esi + 4]
            //   89542448             | mov                 dword ptr [esp + 0x48], edx
            //   8d542428             | lea                 edx, [esp + 0x28]
            //   8b4608               | mov                 eax, dword ptr [esi + 8]

        $sequence_8 = { 8b44240c 8b35???????? 50 ffd6 8b4c2410 51 ffd6 }
            // n = 7, score = 200
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]
            //   8b35????????         |                     
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   51                   | push                ecx
            //   ffd6                 | call                esi

        $sequence_9 = { 55 56 8be9 57 b940000000 33c0 8dbc242d010000 }
            // n = 7, score = 200
            //   55                   | push                ebp
            //   56                   | push                esi
            //   8be9                 | mov                 ebp, ecx
            //   57                   | push                edi
            //   b940000000           | mov                 ecx, 0x40
            //   33c0                 | xor                 eax, eax
            //   8dbc242d010000       | lea                 edi, [esp + 0x12d]

    condition:
        7 of them and filesize < 90112
}