rule win_deputydog_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.deputydog."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.deputydog"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bcb 33c0 8dbd2efdffff f3ab 66ab ff15???????? 8b3d???????? }
            // n = 7, score = 100
            //   8bcb                 | mov                 ecx, ebx
            //   33c0                 | xor                 eax, eax
            //   8dbd2efdffff         | lea                 edi, [ebp - 0x2d2]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   ff15????????         |                     
            //   8b3d????????         |                     

        $sequence_1 = { 8b5108 894108 8b4508 5f }
            // n = 4, score = 100
            //   8b5108               | mov                 edx, dword ptr [ecx + 8]
            //   894108               | mov                 dword ptr [ecx + 8], eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   5f                   | pop                 edi

        $sequence_2 = { 897df0 53 50 8d8538ffffff }
            // n = 4, score = 100
            //   897df0               | mov                 dword ptr [ebp - 0x10], edi
            //   53                   | push                ebx
            //   50                   | push                eax
            //   8d8538ffffff         | lea                 eax, [ebp - 0xc8]

        $sequence_3 = { 8b4718 8b30 3bf0 0f8482000000 8b4e08 8d45e0 50 }
            // n = 7, score = 100
            //   8b4718               | mov                 eax, dword ptr [edi + 0x18]
            //   8b30                 | mov                 esi, dword ptr [eax]
            //   3bf0                 | cmp                 esi, eax
            //   0f8482000000         | je                  0x88
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax

        $sequence_4 = { 885dfc 59 8906 57 8d4dc8 ff15???????? 834dfcff }
            // n = 7, score = 100
            //   885dfc               | mov                 byte ptr [ebp - 4], bl
            //   59                   | pop                 ecx
            //   8906                 | mov                 dword ptr [esi], eax
            //   57                   | push                edi
            //   8d4dc8               | lea                 ecx, [ebp - 0x38]
            //   ff15????????         |                     
            //   834dfcff             | or                  dword ptr [ebp - 4], 0xffffffff

        $sequence_5 = { 56 6a03 33d2 5b 8bcb f7f1 8b4d0c }
            // n = 7, score = 100
            //   56                   | push                esi
            //   6a03                 | push                3
            //   33d2                 | xor                 edx, edx
            //   5b                   | pop                 ebx
            //   8bcb                 | mov                 ecx, ebx
            //   f7f1                 | div                 ecx
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]

        $sequence_6 = { 8b7e08 8d1419 397d08 7417 8bc2 2bc1 2bc3 }
            // n = 7, score = 100
            //   8b7e08               | mov                 edi, dword ptr [esi + 8]
            //   8d1419               | lea                 edx, [ecx + ebx]
            //   397d08               | cmp                 dword ptr [ebp + 8], edi
            //   7417                 | je                  0x19
            //   8bc2                 | mov                 eax, edx
            //   2bc1                 | sub                 eax, ecx
            //   2bc3                 | sub                 eax, ebx

        $sequence_7 = { e8???????? 8bf0 ff7514 8b06 834dfcff }
            // n = 5, score = 100
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   834dfcff             | or                  dword ptr [ebp - 4], 0xffffffff

        $sequence_8 = { 55 50 ffd3 ff7624 ffd7 896e24 8b4614 }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   ff7624               | push                dword ptr [esi + 0x24]
            //   ffd7                 | call                edi
            //   896e24               | mov                 dword ptr [esi + 0x24], ebp
            //   8b4614               | mov                 eax, dword ptr [esi + 0x14]

        $sequence_9 = { 5f 0f84e9000000 8b7108 2bf0 3bf7 0f85a0000000 3810 }
            // n = 7, score = 100
            //   5f                   | pop                 edi
            //   0f84e9000000         | je                  0xef
            //   8b7108               | mov                 esi, dword ptr [ecx + 8]
            //   2bf0                 | sub                 esi, eax
            //   3bf7                 | cmp                 esi, edi
            //   0f85a0000000         | jne                 0xa6
            //   3810                 | cmp                 byte ptr [eax], dl

    condition:
        7 of them and filesize < 90112
}