rule win_devopt_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.devopt."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.devopt"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4df4 ff91fc000000 8945ec 8b55fc 8b45f4 8b4df4 ff9100010000 }
            // n = 7, score = 100
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   ff91fc000000         | call                dword ptr [ecx + 0xfc]
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   ff9100010000         | call                dword ptr [ecx + 0x100]

        $sequence_1 = { ff969c000000 e9???????? 8b45fc 8b806c030000 8b80a4000000 8b55fc 8b929c000000 }
            // n = 7, score = 100
            //   ff969c000000         | call                dword ptr [esi + 0x9c]
            //   e9????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b806c030000         | mov                 eax, dword ptr [eax + 0x36c]
            //   8b80a4000000         | mov                 eax, dword ptr [eax + 0xa4]
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8b929c000000         | mov                 edx, dword ptr [edx + 0x9c]

        $sequence_2 = { eb36 c745ecffffffff 8db42600000000 8b45ec 8d4001 8945ec 8b45fc }
            // n = 7, score = 100
            //   eb36                 | jmp                 0x38
            //   c745ecffffffff       | mov                 dword ptr [ebp - 0x14], 0xffffffff
            //   8db42600000000       | lea                 esi, [esi]
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   8d4001               | lea                 eax, [eax + 1]
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_3 = { ff75e4 e8???????? a9ffffffff 7402 eb0e ba???????? 89e8 }
            // n = 7, score = 100
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   e8????????           |                     
            //   a9ffffffff           | test                eax, 0xffffffff
            //   7402                 | je                  4
            //   eb0e                 | jmp                 0x10
            //   ba????????           |                     
            //   89e8                 | mov                 eax, ebp

        $sequence_4 = { eb1b 81fa6079feff 7e07 3df0d8ffff 7f08 66c74590f0d8 eb04 }
            // n = 7, score = 100
            //   eb1b                 | jmp                 0x1d
            //   81fa6079feff         | cmp                 edx, 0xfffe7960
            //   7e07                 | jle                 9
            //   3df0d8ffff           | cmp                 eax, 0xffffd8f0
            //   7f08                 | jg                  0xa
            //   66c74590f0d8         | mov                 word ptr [ebp - 0x70], 0xd8f0
            //   eb04                 | jmp                 6

        $sequence_5 = { e8???????? 84c0 7502 eb1e 8b45f8 8b40f8 8b55f0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7502                 | jne                 4
            //   eb1e                 | jmp                 0x20
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8b40f8               | mov                 eax, dword ptr [eax - 8]
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]

        $sequence_6 = { f77908 89c1 8b45ec ba01000000 8b7dec 8b5f04 ff5308 }
            // n = 7, score = 100
            //   f77908               | idiv                dword ptr [ecx + 8]
            //   89c1                 | mov                 ecx, eax
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   ba01000000           | mov                 edx, 1
            //   8b7dec               | mov                 edi, dword ptr [ebp - 0x14]
            //   8b5f04               | mov                 ebx, dword ptr [edi + 4]
            //   ff5308               | call                dword ptr [ebx + 8]

        $sequence_7 = { ba00000000 e8???????? b101 ba01000000 b8???????? e8???????? 8b55f4 }
            // n = 7, score = 100
            //   ba00000000           | mov                 edx, 0
            //   e8????????           |                     
            //   b101                 | mov                 cl, 1
            //   ba01000000           | mov                 edx, 1
            //   b8????????           |                     
            //   e8????????           |                     
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]

        $sequence_8 = { 8d4de0 8d55d8 8b45f4 8b5df4 8b1b ff9334030000 8b5510 }
            // n = 7, score = 100
            //   8d4de0               | lea                 ecx, [ebp - 0x20]
            //   8d55d8               | lea                 edx, [ebp - 0x28]
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8b5df4               | mov                 ebx, dword ptr [ebp - 0xc]
            //   8b1b                 | mov                 ebx, dword ptr [ebx]
            //   ff9334030000         | call                dword ptr [ebx + 0x334]
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]

        $sequence_9 = { ff537c 8b45f0 85c0 7403 8b40fc 8945f4 8b45fc }
            // n = 7, score = 100
            //   ff537c               | call                dword ptr [ebx + 0x7c]
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   85c0                 | test                eax, eax
            //   7403                 | je                  5
            //   8b40fc               | mov                 eax, dword ptr [eax - 4]
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

    condition:
        7 of them and filesize < 4645888
}