rule win_dexbia_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.dexbia."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dexbia"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bcb 8d442410 83e103 50 f3a4 68???????? ff15???????? }
            // n = 7, score = 200
            //   8bcb                 | mov                 ecx, ebx
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   83e103               | and                 ecx, 3
            //   50                   | push                eax
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_1 = { b85c140000 e8???????? 55 56 57 }
            // n = 5, score = 200
            //   b85c140000           | mov                 eax, 0x145c
            //   e8????????           |                     
            //   55                   | push                ebp
            //   56                   | push                esi
            //   57                   | push                edi

        $sequence_2 = { 33c0 83c40c f2ae f7d1 2bf9 8d54247c 8bf7 }
            // n = 7, score = 200
            //   33c0                 | xor                 eax, eax
            //   83c40c               | add                 esp, 0xc
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   2bf9                 | sub                 edi, ecx
            //   8d54247c             | lea                 edx, [esp + 0x7c]
            //   8bf7                 | mov                 esi, edi

        $sequence_3 = { f3a5 8bca 83c020 83e103 8d9424a0120000 f3a4 }
            // n = 6, score = 200
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bca                 | mov                 ecx, edx
            //   83c020               | add                 eax, 0x20
            //   83e103               | and                 ecx, 3
            //   8d9424a0120000       | lea                 edx, [esp + 0x12a0]
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]

        $sequence_4 = { 68???????? f3ab 8b0d???????? 66ab aa }
            // n = 5, score = 200
            //   68????????           |                     
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8b0d????????         |                     
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al

        $sequence_5 = { 51 68???????? 68???????? 68???????? e8???????? 83c428 85c0 }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   68????????           |                     
            //   68????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   83c428               | add                 esp, 0x28
            //   85c0                 | test                eax, eax

        $sequence_6 = { c786a801000000000000 8d8ef8000000 8d9638010000 51 52 e8???????? }
            // n = 6, score = 200
            //   c786a801000000000000     | mov    dword ptr [esi + 0x1a8], 0
            //   8d8ef8000000         | lea                 ecx, [esi + 0xf8]
            //   8d9638010000         | lea                 edx, [esi + 0x138]
            //   51                   | push                ecx
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_7 = { ff248579354000 834df0ff 8955cc 8955d8 8955e0 }
            // n = 5, score = 200
            //   ff248579354000       | jmp                 dword ptr [eax*4 + 0x403579]
            //   834df0ff             | or                  dword ptr [ebp - 0x10], 0xffffffff
            //   8955cc               | mov                 dword ptr [ebp - 0x34], edx
            //   8955d8               | mov                 dword ptr [ebp - 0x28], edx
            //   8955e0               | mov                 dword ptr [ebp - 0x20], edx

        $sequence_8 = { 8be8 85ed 7522 ff15???????? 8b35???????? 53 ffd6 }
            // n = 7, score = 200
            //   8be8                 | mov                 ebp, eax
            //   85ed                 | test                ebp, ebp
            //   7522                 | jne                 0x24
            //   ff15????????         |                     
            //   8b35????????         |                     
            //   53                   | push                ebx
            //   ffd6                 | call                esi

        $sequence_9 = { f3ab 66ab aa 8b442410 b908000000 8dbc249c120000 6800140000 }
            // n = 7, score = 200
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   b908000000           | mov                 ecx, 8
            //   8dbc249c120000       | lea                 edi, [esp + 0x129c]
            //   6800140000           | push                0x1400

    condition:
        7 of them and filesize < 106496
}