rule win_dimnie_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.dimnie."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dimnie"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 2b5508 83fa01 751c 0f31 }
            // n = 4, score = 400
            //   2b5508               | sub                 edx, dword ptr [ebp + 8]
            //   83fa01               | cmp                 edx, 1
            //   751c                 | jne                 0x1e
            //   0f31                 | rdtsc               

        $sequence_1 = { 7605 8b450c eb54 8b550c 2b5508 83fa01 751c }
            // n = 7, score = 400
            //   7605                 | jbe                 7
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   eb54                 | jmp                 0x56
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   2b5508               | sub                 edx, dword ptr [ebp + 8]
            //   83fa01               | cmp                 edx, 1
            //   751c                 | jne                 0x1e

        $sequence_2 = { 8855ae eb04 c645ae3d 8b450c }
            // n = 4, score = 400
            //   8855ae               | mov                 byte ptr [ebp - 0x52], dl
            //   eb04                 | jmp                 6
            //   c645ae3d             | mov                 byte ptr [ebp - 0x52], 0x3d
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_3 = { 890a 8b4510 8b08 83e107 }
            // n = 4, score = 400
            //   890a                 | mov                 dword ptr [edx], ecx
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   83e107               | and                 ecx, 7

        $sequence_4 = { 8b4d08 3b4d0c 7605 8b450c eb54 8b550c 2b5508 }
            // n = 7, score = 400
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   3b4d0c               | cmp                 ecx, dword ptr [ebp + 0xc]
            //   7605                 | jbe                 7
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   eb54                 | jmp                 0x56
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   2b5508               | sub                 edx, dword ptr [ebp + 8]

        $sequence_5 = { c70101000000 8b5510 c70201000000 8b4508 8b08 }
            // n = 5, score = 400
            //   c70101000000         | mov                 dword ptr [ecx], 1
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   c70201000000         | mov                 dword ptr [edx], 1
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_6 = { c1e804 8945f4 8b4df8 83c101 8b45f4 33d2 f7f1 }
            // n = 7, score = 400
            //   c1e804               | shr                 eax, 4
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   83c101               | add                 ecx, 1
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   33d2                 | xor                 edx, edx
            //   f7f1                 | div                 ecx

        $sequence_7 = { c745fc00000000 c745f800000000 c745f850000000 8b450c }
            // n = 4, score = 400
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   c745f850000000       | mov                 dword ptr [ebp - 8], 0x50
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_8 = { 8b5510 c70201000000 8b4508 8b08 83e10f }
            // n = 5, score = 400
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   c70201000000         | mov                 dword ptr [edx], 1
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   83e10f               | and                 ecx, 0xf

        $sequence_9 = { 83c101 8b45f4 33d2 f7f1 }
            // n = 4, score = 400
            //   83c101               | add                 ecx, 1
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   33d2                 | xor                 edx, edx
            //   f7f1                 | div                 ecx

    condition:
        7 of them and filesize < 212992
}