rule win_dnespy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.dnespy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dnespy"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c410 3bc1 7412 8bc3 83ceff 2bc1 03f8 }
            // n = 7, score = 200
            //   83c410               | add                 esp, 0x10
            //   3bc1                 | cmp                 eax, ecx
            //   7412                 | je                  0x14
            //   8bc3                 | mov                 eax, ebx
            //   83ceff               | or                  esi, 0xffffffff
            //   2bc1                 | sub                 eax, ecx
            //   03f8                 | add                 edi, eax

        $sequence_1 = { 8d4d88 e8???????? 83e7fd 83cf01 c745fc06000000 8b45b0 }
            // n = 6, score = 200
            //   8d4d88               | lea                 ecx, [ebp - 0x78]
            //   e8????????           |                     
            //   83e7fd               | and                 edi, 0xfffffffd
            //   83cf01               | or                  edi, 1
            //   c745fc06000000       | mov                 dword ptr [ebp - 4], 6
            //   8b45b0               | mov                 eax, dword ptr [ebp - 0x50]

        $sequence_2 = { 83c408 8b951cfeffff c78584feffff00000000 c78588feffff0f000000 c68574feffff00 83fa10 }
            // n = 6, score = 200
            //   83c408               | add                 esp, 8
            //   8b951cfeffff         | mov                 edx, dword ptr [ebp - 0x1e4]
            //   c78584feffff00000000     | mov    dword ptr [ebp - 0x17c], 0
            //   c78588feffff0f000000     | mov    dword ptr [ebp - 0x178], 0xf
            //   c68574feffff00       | mov                 byte ptr [ebp - 0x18c], 0
            //   83fa10               | cmp                 edx, 0x10

        $sequence_3 = { 51 e8???????? 83c408 83c8ff 5f 5e 5b }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   83c8ff               | or                  eax, 0xffffffff
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_4 = { 040d 3474 888575ffffff 8b8564ffffff 040e 3420 }
            // n = 6, score = 200
            //   040d                 | add                 al, 0xd
            //   3474                 | xor                 al, 0x74
            //   888575ffffff         | mov                 byte ptr [ebp - 0x8b], al
            //   8b8564ffffff         | mov                 eax, dword ptr [ebp - 0x9c]
            //   040e                 | add                 al, 0xe
            //   3420                 | xor                 al, 0x20

        $sequence_5 = { 83eb01 75eb 836c241401 0f85b0feffff 8bf7 8d5a04 8bce }
            // n = 7, score = 200
            //   83eb01               | sub                 ebx, 1
            //   75eb                 | jne                 0xffffffed
            //   836c241401           | sub                 dword ptr [esp + 0x14], 1
            //   0f85b0feffff         | jne                 0xfffffeb6
            //   8bf7                 | mov                 esi, edi
            //   8d5a04               | lea                 ebx, [edx + 4]
            //   8bce                 | mov                 ecx, esi

        $sequence_6 = { c68521f7ffff7e c68522f7ffff6f c68523f7ffff78 c68524f7ffff7e c68525f7ffff37 c68526f7ffff5e c68527f7ffff83 }
            // n = 7, score = 200
            //   c68521f7ffff7e       | mov                 byte ptr [ebp - 0x8df], 0x7e
            //   c68522f7ffff6f       | mov                 byte ptr [ebp - 0x8de], 0x6f
            //   c68523f7ffff78       | mov                 byte ptr [ebp - 0x8dd], 0x78
            //   c68524f7ffff7e       | mov                 byte ptr [ebp - 0x8dc], 0x7e
            //   c68525f7ffff37       | mov                 byte ptr [ebp - 0x8db], 0x37
            //   c68526f7ffff5e       | mov                 byte ptr [ebp - 0x8da], 0x5e
            //   c68527f7ffff83       | mov                 byte ptr [ebp - 0x8d9], 0x83

        $sequence_7 = { 346c 8885e2f7ffff 8b8578f7ffff 0467 3461 8885e3f7ffff 8b8578f7ffff }
            // n = 7, score = 200
            //   346c                 | xor                 al, 0x6c
            //   8885e2f7ffff         | mov                 byte ptr [ebp - 0x81e], al
            //   8b8578f7ffff         | mov                 eax, dword ptr [ebp - 0x888]
            //   0467                 | add                 al, 0x67
            //   3461                 | xor                 al, 0x61
            //   8885e3f7ffff         | mov                 byte ptr [ebp - 0x81d], al
            //   8b8578f7ffff         | mov                 eax, dword ptr [ebp - 0x888]

        $sequence_8 = { ff15???????? 83c408 85c0 7553 8b451c 8b5e0c 894640 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   7553                 | jne                 0x55
            //   8b451c               | mov                 eax, dword ptr [ebp + 0x1c]
            //   8b5e0c               | mov                 ebx, dword ptr [esi + 0xc]
            //   894640               | mov                 dword ptr [esi + 0x40], eax

        $sequence_9 = { e8???????? c645fc01 8b55b4 8bc2 8b4db0 2bc1 83f801 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   8b55b4               | mov                 edx, dword ptr [ebp - 0x4c]
            //   8bc2                 | mov                 eax, edx
            //   8b4db0               | mov                 ecx, dword ptr [ebp - 0x50]
            //   2bc1                 | sub                 eax, ecx
            //   83f801               | cmp                 eax, 1

    condition:
        7 of them and filesize < 794624
}