rule win_dnspionage_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.dnspionage."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dnspionage"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c408 2bdf 78cc 8d4301 50 e8???????? 83c404 }
            // n = 7, score = 300
            //   83c408               | add                 esp, 8
            //   2bdf                 | sub                 ebx, edi
            //   78cc                 | js                  0xffffffce
            //   8d4301               | lea                 eax, [ebx + 1]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_1 = { eb52 8d0492 8d144503000000 eb46 8d0492 }
            // n = 5, score = 300
            //   eb52                 | jmp                 0x54
            //   8d0492               | lea                 eax, [edx + edx*4]
            //   8d144503000000       | lea                 edx, [eax*2 + 3]
            //   eb46                 | jmp                 0x48
            //   8d0492               | lea                 eax, [edx + edx*4]

        $sequence_2 = { 894dfc 57 8bfa 85f6 0f8487000000 }
            // n = 5, score = 300
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   57                   | push                edi
            //   8bfa                 | mov                 edi, edx
            //   85f6                 | test                esi, esi
            //   0f8487000000         | je                  0x8d

        $sequence_3 = { 7ed9 53 ff15???????? 8b4dfc }
            // n = 4, score = 300
            //   7ed9                 | jle                 0xffffffdb
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_4 = { 8d4d0c ba???????? 51 8d4df4 51 8bc8 }
            // n = 6, score = 300
            //   8d4d0c               | lea                 ecx, [ebp + 0xc]
            //   ba????????           |                     
            //   51                   | push                ecx
            //   8d4df4               | lea                 ecx, [ebp - 0xc]
            //   51                   | push                ecx
            //   8bc8                 | mov                 ecx, eax

        $sequence_5 = { e8???????? 8b4de4 83c404 33f6 8945e8 }
            // n = 5, score = 300
            //   e8????????           |                     
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]
            //   83c404               | add                 esp, 4
            //   33f6                 | xor                 esi, esi
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax

        $sequence_6 = { e8???????? 8b450c 83c404 83f8ff 7503 50 }
            // n = 6, score = 300
            //   e8????????           |                     
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   83c404               | add                 esp, 4
            //   83f8ff               | cmp                 eax, -1
            //   7503                 | jne                 5
            //   50                   | push                eax

        $sequence_7 = { 897dfc 85f6 7508 5f 33c0 5e 8be5 }
            // n = 7, score = 300
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   85f6                 | test                esi, esi
            //   7508                 | jne                 0xa
            //   5f                   | pop                 edi
            //   33c0                 | xor                 eax, eax
            //   5e                   | pop                 esi
            //   8be5                 | mov                 esp, ebp

        $sequence_8 = { 8bf2 2bf9 8d4e01 6690 }
            // n = 4, score = 300
            //   8bf2                 | mov                 esi, edx
            //   2bf9                 | sub                 edi, ecx
            //   8d4e01               | lea                 ecx, [esi + 1]
            //   6690                 | nop                 

        $sequence_9 = { 8b4ddc 85db 0f8563ffffff 8975f0 85f6 0f84a0000000 8bc6 }
            // n = 7, score = 300
            //   8b4ddc               | mov                 ecx, dword ptr [ebp - 0x24]
            //   85db                 | test                ebx, ebx
            //   0f8563ffffff         | jne                 0xffffff69
            //   8975f0               | mov                 dword ptr [ebp - 0x10], esi
            //   85f6                 | test                esi, esi
            //   0f84a0000000         | je                  0xa6
            //   8bc6                 | mov                 eax, esi

    condition:
        7 of them and filesize < 786432
}