rule win_doppelpaymer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.doppelpaymer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.doppelpaymer"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 80790600 7523 80790264 751d }
            // n = 4, score = 700
            //   80790600             | cmp                 byte ptr [ecx + 6], 0
            //   7523                 | jne                 0x25
            //   80790264             | cmp                 byte ptr [ecx + 2], 0x64
            //   751d                 | jne                 0x1f

        $sequence_1 = { e8???????? 8b08 e8???????? 3db6389096 }
            // n = 4, score = 700
            //   e8????????           |                     
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   e8????????           |                     
            //   3db6389096           | cmp                 eax, 0x969038b6

        $sequence_2 = { 7517 80790361 7511 80790474 750b 80790173 7505 }
            // n = 7, score = 700
            //   7517                 | jne                 0x19
            //   80790361             | cmp                 byte ptr [ecx + 3], 0x61
            //   7511                 | jne                 0x13
            //   80790474             | cmp                 byte ptr [ecx + 4], 0x74
            //   750b                 | jne                 0xd
            //   80790173             | cmp                 byte ptr [ecx + 1], 0x73
            //   7505                 | jne                 7

        $sequence_3 = { 83ec28 6800002002 6a00 6a01 }
            // n = 4, score = 700
            //   83ec28               | sub                 esp, 0x28
            //   6800002002           | push                0x2200000
            //   6a00                 | push                0
            //   6a01                 | push                1

        $sequence_4 = { 80790264 751d 80790561 7517 80790361 }
            // n = 5, score = 700
            //   80790264             | cmp                 byte ptr [ecx + 2], 0x64
            //   751d                 | jne                 0x1f
            //   80790561             | cmp                 byte ptr [ecx + 5], 0x61
            //   7517                 | jne                 0x19
            //   80790361             | cmp                 byte ptr [ecx + 3], 0x61

        $sequence_5 = { baffffff7f 43 e8???????? 3bd8 }
            // n = 4, score = 700
            //   baffffff7f           | mov                 edx, 0x7fffffff
            //   43                   | inc                 ebx
            //   e8????????           |                     
            //   3bd8                 | cmp                 ebx, eax

        $sequence_6 = { 50 8d4c2454 e8???????? 8bcb e8???????? 8d4c2450 e8???????? }
            // n = 7, score = 600
            //   50                   | push                eax
            //   8d4c2454             | lea                 ecx, [esp + 0x54]
            //   e8????????           |                     
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   8d4c2450             | lea                 ecx, [esp + 0x50]
            //   e8????????           |                     

        $sequence_7 = { 50 ffd2 8bd8 8b442404 80780400 741b 8b00 }
            // n = 7, score = 600
            //   50                   | push                eax
            //   ffd2                 | call                edx
            //   8bd8                 | mov                 ebx, eax
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   80780400             | cmp                 byte ptr [eax + 4], 0
            //   741b                 | je                  0x1d
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_8 = { c20400 8d8d5cfdffff e8???????? 80bd50fdffff00 }
            // n = 4, score = 100
            //   c20400               | ret                 4
            //   8d8d5cfdffff         | lea                 ecx, [ebp - 0x2a4]
            //   e8????????           |                     
            //   80bd50fdffff00       | cmp                 byte ptr [ebp - 0x2b0], 0

        $sequence_9 = { c20400 8d4de8 e8???????? 8b4df4 8bf1 85c9 74ad }
            // n = 7, score = 100
            //   c20400               | ret                 4
            //   8d4de8               | lea                 ecx, [ebp - 0x18]
            //   e8????????           |                     
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   8bf1                 | mov                 esi, ecx
            //   85c9                 | test                ecx, ecx
            //   74ad                 | je                  0xffffffaf

        $sequence_10 = { e8???????? 8b4dd8 890c24 8b55e8 89542404 8945bc e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b4dd8               | mov                 ecx, dword ptr [ebp - 0x28]
            //   890c24               | mov                 dword ptr [esp], ecx
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   89542404             | mov                 dword ptr [esp + 4], edx
            //   8945bc               | mov                 dword ptr [ebp - 0x44], eax
            //   e8????????           |                     

        $sequence_11 = { 31c9 c745f469d9900b 8b5034 8b4008 8955f0 8945ec }
            // n = 6, score = 100
            //   31c9                 | xor                 ecx, ecx
            //   c745f469d9900b       | mov                 dword ptr [ebp - 0xc], 0xb90d969
            //   8b5034               | mov                 edx, dword ptr [eax + 0x34]
            //   8b4008               | mov                 eax, dword ptr [eax + 8]
            //   8955f0               | mov                 dword ptr [ebp - 0x10], edx
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax

        $sequence_12 = { 8b75ec 81c61d0b66d6 8b7dc0 897904 }
            // n = 4, score = 100
            //   8b75ec               | mov                 esi, dword ptr [ebp - 0x14]
            //   81c61d0b66d6         | add                 esi, 0xd6660b1d
            //   8b7dc0               | mov                 edi, dword ptr [ebp - 0x40]
            //   897904               | mov                 dword ptr [ecx + 4], edi

        $sequence_13 = { 8945c4 74d0 e9???????? 31c0 }
            // n = 4, score = 100
            //   8945c4               | mov                 dword ptr [ebp - 0x3c], eax
            //   74d0                 | je                  0xffffffd2
            //   e9????????           |                     
            //   31c0                 | xor                 eax, eax

        $sequence_14 = { e8???????? 8b4de8 8b55d8 895128 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   8b55d8               | mov                 edx, dword ptr [ebp - 0x28]
            //   895128               | mov                 dword ptr [ecx + 0x28], edx

        $sequence_15 = { 894c2404 8945d8 e8???????? 31c0 8b4de8 8b5108 8b7134 }
            // n = 7, score = 100
            //   894c2404             | mov                 dword ptr [esp + 4], ecx
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   e8????????           |                     
            //   31c0                 | xor                 eax, eax
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   8b5108               | mov                 edx, dword ptr [ecx + 8]
            //   8b7134               | mov                 esi, dword ptr [ecx + 0x34]

        $sequence_16 = { 8d75d1 c745f0e7566258 c645ef3c 8a1d???????? 80fb00 8945c0 894dbc }
            // n = 7, score = 100
            //   8d75d1               | lea                 esi, [ebp - 0x2f]
            //   c745f0e7566258       | mov                 dword ptr [ebp - 0x10], 0x586256e7
            //   c645ef3c             | mov                 byte ptr [ebp - 0x11], 0x3c
            //   8a1d????????         |                     
            //   80fb00               | cmp                 bl, 0
            //   8945c0               | mov                 dword ptr [ebp - 0x40], eax
            //   894dbc               | mov                 dword ptr [ebp - 0x44], ecx

        $sequence_17 = { 8b7e50 897db8 8b7e3c 897dbc 8b7e10 897dc0 8b7e18 }
            // n = 7, score = 100
            //   8b7e50               | mov                 edi, dword ptr [esi + 0x50]
            //   897db8               | mov                 dword ptr [ebp - 0x48], edi
            //   8b7e3c               | mov                 edi, dword ptr [esi + 0x3c]
            //   897dbc               | mov                 dword ptr [ebp - 0x44], edi
            //   8b7e10               | mov                 edi, dword ptr [esi + 0x10]
            //   897dc0               | mov                 dword ptr [ebp - 0x40], edi
            //   8b7e18               | mov                 edi, dword ptr [esi + 0x18]

    condition:
        7 of them and filesize < 7266304
}