rule win_downeks_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.downeks."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.downeks"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { bfc4010904 8d44241c e8???????? 50 8d4c2428 6a40 51 }
            // n = 7, score = 200
            //   bfc4010904           | mov                 edi, 0x40901c4
            //   8d44241c             | lea                 eax, [esp + 0x1c]
            //   e8????????           |                     
            //   50                   | push                eax
            //   8d4c2428             | lea                 ecx, [esp + 0x28]
            //   6a40                 | push                0x40
            //   51                   | push                ecx

        $sequence_1 = { 0f8db6000000 897df8 8bc6 99 f77dfc 8b4cb7fc 85d2 }
            // n = 7, score = 200
            //   0f8db6000000         | jge                 0xbc
            //   897df8               | mov                 dword ptr [ebp - 8], edi
            //   8bc6                 | mov                 eax, esi
            //   99                   | cdq                 
            //   f77dfc               | idiv                dword ptr [ebp - 4]
            //   8b4cb7fc             | mov                 ecx, dword ptr [edi + esi*4 - 4]
            //   85d2                 | test                edx, edx

        $sequence_2 = { e8???????? 8b4d08 5f 8b06 8b5004 015804 8d74100c }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   5f                   | pop                 edi
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8b5004               | mov                 edx, dword ptr [eax + 4]
            //   015804               | add                 dword ptr [eax + 4], ebx
            //   8d74100c             | lea                 esi, [eax + edx + 0xc]

        $sequence_3 = { b9081c0904 e8???????? 83c404 85c0 7e2f 50 68ec210904 }
            // n = 7, score = 200
            //   b9081c0904           | mov                 ecx, 0x4091c08
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   7e2f                 | jle                 0x31
            //   50                   | push                eax
            //   68ec210904           | push                0x40921ec

        $sequence_4 = { c3 68ec140804 56 e8???????? 83c408 5e 8be5 }
            // n = 7, score = 200
            //   c3                   | ret                 
            //   68ec140804           | push                0x40814ec
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   5e                   | pop                 esi
            //   8be5                 | mov                 esp, ebp

        $sequence_5 = { eb34 81fefc000000 7507 bf544e0804 eb25 81fefd000000 7507 }
            // n = 7, score = 200
            //   eb34                 | jmp                 0x36
            //   81fefc000000         | cmp                 esi, 0xfc
            //   7507                 | jne                 9
            //   bf544e0804           | mov                 edi, 0x4084e54
            //   eb25                 | jmp                 0x27
            //   81fefd000000         | cmp                 esi, 0xfd
            //   7507                 | jne                 9

        $sequence_6 = { c7401002010000 5f 5d c20400 837f1800 7417 6879020000 }
            // n = 7, score = 200
            //   c7401002010000       | mov                 dword ptr [eax + 0x10], 0x102
            //   5f                   | pop                 edi
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   837f1800             | cmp                 dword ptr [edi + 0x18], 0
            //   7417                 | je                  0x19
            //   6879020000           | push                0x279

        $sequence_7 = { 8b8d74ffffff 51 e8???????? 83c404 897588 895d84 889d74ffffff }
            // n = 7, score = 200
            //   8b8d74ffffff         | mov                 ecx, dword ptr [ebp - 0x8c]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   897588               | mov                 dword ptr [ebp - 0x78], esi
            //   895d84               | mov                 dword ptr [ebp - 0x7c], ebx
            //   889d74ffffff         | mov                 byte ptr [ebp - 0x8c], bl

        $sequence_8 = { 8bec 53 8b5d08 8b4330 56 33f6 57 }
            // n = 7, score = 200
            //   8bec                 | mov                 ebp, esp
            //   53                   | push                ebx
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   8b4330               | mov                 eax, dword ptr [ebx + 0x30]
            //   56                   | push                esi
            //   33f6                 | xor                 esi, esi
            //   57                   | push                edi

        $sequence_9 = { e9???????? 8d7dc4 e9???????? 8d7dc0 e9???????? 8d7dc4 e9???????? }
            // n = 7, score = 200
            //   e9????????           |                     
            //   8d7dc4               | lea                 edi, [ebp - 0x3c]
            //   e9????????           |                     
            //   8d7dc0               | lea                 edi, [ebp - 0x40]
            //   e9????????           |                     
            //   8d7dc4               | lea                 edi, [ebp - 0x3c]
            //   e9????????           |                     

    condition:
        7 of them and filesize < 1318912
}