rule win_dramnudge_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.dramnudge."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dramnudge"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c0 894590 8b5590 8955f8 8d4df0 894d8c }
            // n = 6, score = 100
            //   33c0                 | xor                 eax, eax
            //   894590               | mov                 dword ptr [ebp - 0x70], eax
            //   8b5590               | mov                 edx, dword ptr [ebp - 0x70]
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   8d4df0               | lea                 ecx, [ebp - 0x10]
            //   894d8c               | mov                 dword ptr [ebp - 0x74], ecx

        $sequence_1 = { 8bcb 895808 89480c 895010 8b400c 33d2 }
            // n = 6, score = 100
            //   8bcb                 | mov                 ecx, ebx
            //   895808               | mov                 dword ptr [eax + 8], ebx
            //   89480c               | mov                 dword ptr [eax + 0xc], ecx
            //   895010               | mov                 dword ptr [eax + 0x10], edx
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   33d2                 | xor                 edx, edx

        $sequence_2 = { 59 03c6 50 e8???????? 83c40c 53 e8???????? }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   03c6                 | add                 eax, esi
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   53                   | push                ebx
            //   e8????????           |                     

        $sequence_3 = { 52 51 8b45b0 50 8d45f8 }
            // n = 5, score = 100
            //   52                   | push                edx
            //   51                   | push                ecx
            //   8b45b0               | mov                 eax, dword ptr [ebp - 0x50]
            //   50                   | push                eax
            //   8d45f8               | lea                 eax, [ebp - 8]

        $sequence_4 = { 66c745c41400 51 e8???????? 59 50 53 }
            // n = 6, score = 100
            //   66c745c41400         | mov                 word ptr [ebp - 0x3c], 0x14
            //   51                   | push                ecx
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   50                   | push                eax
            //   53                   | push                ebx

        $sequence_5 = { 56 e8???????? 59 8bd8 53 53 8b4508 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8bd8                 | mov                 ebx, eax
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_6 = { 7602 8bf7 8bc7 0bc6 7516 e8???????? 50 }
            // n = 7, score = 100
            //   7602                 | jbe                 4
            //   8bf7                 | mov                 esi, edi
            //   8bc7                 | mov                 eax, edi
            //   0bc6                 | or                  eax, esi
            //   7516                 | jne                 0x18
            //   e8????????           |                     
            //   50                   | push                eax

        $sequence_7 = { c1e204 83c204 52 e8???????? 59 }
            // n = 5, score = 100
            //   c1e204               | shl                 edx, 4
            //   83c204               | add                 edx, 4
            //   52                   | push                edx
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_8 = { 40 750f 6a01 8b13 8b0a 51 }
            // n = 6, score = 100
            //   40                   | inc                 eax
            //   750f                 | jne                 0x11
            //   6a01                 | push                1
            //   8b13                 | mov                 edx, dword ptr [ebx]
            //   8b0a                 | mov                 ecx, dword ptr [edx]
            //   51                   | push                ecx

        $sequence_9 = { 7409 57 ff5334 59 8bf0 eb09 }
            // n = 6, score = 100
            //   7409                 | je                  0xb
            //   57                   | push                edi
            //   ff5334               | call                dword ptr [ebx + 0x34]
            //   59                   | pop                 ecx
            //   8bf0                 | mov                 esi, eax
            //   eb09                 | jmp                 0xb

    condition:
        7 of them and filesize < 1294336
}