rule win_electric_powder_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.electric_powder."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.electric_powder"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 e8???????? 8bf0 83c404 85f6 0f84f4000000 8b8d40efffff }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   83c404               | add                 esp, 4
            //   85f6                 | test                esi, esi
            //   0f84f4000000         | je                  0xfa
            //   8b8d40efffff         | mov                 ecx, dword ptr [ebp - 0x10c0]

        $sequence_1 = { e8???????? 8d8d70fbffff c645fc4e 51 8bd0 8d8d30fcffff e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d8d70fbffff         | lea                 ecx, [ebp - 0x490]
            //   c645fc4e             | mov                 byte ptr [ebp - 4], 0x4e
            //   51                   | push                ecx
            //   8bd0                 | mov                 edx, eax
            //   8d8d30fcffff         | lea                 ecx, [ebp - 0x3d0]
            //   e8????????           |                     

        $sequence_2 = { 8d85d8f9ffff 83c418 8985dceeffff 6a0c 8d85d4eeffff 50 }
            // n = 6, score = 100
            //   8d85d8f9ffff         | lea                 eax, [ebp - 0x628]
            //   83c418               | add                 esp, 0x18
            //   8985dceeffff         | mov                 dword ptr [ebp - 0x1124], eax
            //   6a0c                 | push                0xc
            //   8d85d4eeffff         | lea                 eax, [ebp - 0x112c]
            //   50                   | push                eax

        $sequence_3 = { 6a02 52 56 8bcb ff5508 8bc8 ebe1 }
            // n = 7, score = 100
            //   6a02                 | push                2
            //   52                   | push                edx
            //   56                   | push                esi
            //   8bcb                 | mov                 ecx, ebx
            //   ff5508               | call                dword ptr [ebp + 8]
            //   8bc8                 | mov                 ecx, eax
            //   ebe1                 | jmp                 0xffffffe3

        $sequence_4 = { 8d4738 50 51 8d8d98efffff }
            // n = 4, score = 100
            //   8d4738               | lea                 eax, [edi + 0x38]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   8d8d98efffff         | lea                 ecx, [ebp - 0x1068]

        $sequence_5 = { 2bc2 8955fc 83f801 0f82ff000000 8b7e14 8d5a01 83cb0f }
            // n = 7, score = 100
            //   2bc2                 | sub                 eax, edx
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   83f801               | cmp                 eax, 1
            //   0f82ff000000         | jb                  0x105
            //   8b7e14               | mov                 edi, dword ptr [esi + 0x14]
            //   8d5a01               | lea                 ebx, [edx + 1]
            //   83cb0f               | or                  ebx, 0xf

        $sequence_6 = { 8bc1 57 8b5e10 2bc3 895df8 3bc2 0f82e9000000 }
            // n = 7, score = 100
            //   8bc1                 | mov                 eax, ecx
            //   57                   | push                edi
            //   8b5e10               | mov                 ebx, dword ptr [esi + 0x10]
            //   2bc3                 | sub                 eax, ebx
            //   895df8               | mov                 dword ptr [ebp - 8], ebx
            //   3bc2                 | cmp                 eax, edx
            //   0f82e9000000         | jb                  0xef

        $sequence_7 = { 8bce 50 e8???????? 84c0 7511 5e c70301000000 }
            // n = 7, score = 100
            //   8bce                 | mov                 ecx, esi
            //   50                   | push                eax
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7511                 | jne                 0x13
            //   5e                   | pop                 esi
            //   c70301000000         | mov                 dword ptr [ebx], 1

        $sequence_8 = { c6854fefffff00 8d8d80efffff e8???????? 8a854fefffff 8b4df4 64890d00000000 59 }
            // n = 7, score = 100
            //   c6854fefffff00       | mov                 byte ptr [ebp - 0x10b1], 0
            //   8d8d80efffff         | lea                 ecx, [ebp - 0x1080]
            //   e8????????           |                     
            //   8a854fefffff         | mov                 al, byte ptr [ebp - 0x10b1]
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   59                   | pop                 ecx

        $sequence_9 = { 8d3400 8945e8 56 51 8d45d8 50 e8???????? }
            // n = 7, score = 100
            //   8d3400               | lea                 esi, [eax + eax]
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   56                   | push                esi
            //   51                   | push                ecx
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   50                   | push                eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 565248
}