rule win_elirks_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.elirks."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.elirks"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7532 ff15???????? 8b4b08 81e1ffffff00 }
            // n = 4, score = 100
            //   7532                 | jne                 0x34
            //   ff15????????         |                     
            //   8b4b08               | mov                 ecx, dword ptr [ebx + 8]
            //   81e1ffffff00         | and                 ecx, 0xffffff

        $sequence_1 = { 83c40c 03d5 8bfd 8916 8b4c2410 8d442418 }
            // n = 6, score = 100
            //   83c40c               | add                 esp, 0xc
            //   03d5                 | add                 edx, ebp
            //   8bfd                 | mov                 edi, ebp
            //   8916                 | mov                 dword ptr [esi], edx
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   8d442418             | lea                 eax, [esp + 0x18]

        $sequence_2 = { 8b4c2408 8d742410 e8???????? 8d742408 e8???????? 5f 5e }
            // n = 7, score = 100
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]
            //   8d742410             | lea                 esi, [esp + 0x10]
            //   e8????????           |                     
            //   8d742408             | lea                 esi, [esp + 8]
            //   e8????????           |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_3 = { 33c0 8bd6 8a0a 80f941 7c0d 80f95a 7f08 }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   8bd6                 | mov                 edx, esi
            //   8a0a                 | mov                 cl, byte ptr [edx]
            //   80f941               | cmp                 cl, 0x41
            //   7c0d                 | jl                  0xf
            //   80f95a               | cmp                 cl, 0x5a
            //   7f08                 | jg                  0xa

        $sequence_4 = { 8d4b01 394c2414 0f8c4bffffff b801000000 5f 5e 5d }
            // n = 7, score = 100
            //   8d4b01               | lea                 ecx, [ebx + 1]
            //   394c2414             | cmp                 dword ptr [esp + 0x14], ecx
            //   0f8c4bffffff         | jl                  0xffffff51
            //   b801000000           | mov                 eax, 1
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp

        $sequence_5 = { 758d 8b4c241c 5b 85c9 7e1d }
            // n = 5, score = 100
            //   758d                 | jne                 0xffffff8f
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   5b                   | pop                 ebx
            //   85c9                 | test                ecx, ecx
            //   7e1d                 | jle                 0x1f

        $sequence_6 = { e8???????? 83c410 85c0 7419 8b44241c 8b4c2418 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   85c0                 | test                eax, eax
            //   7419                 | je                  0x1b
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]
            //   e8????????           |                     

        $sequence_7 = { 56 57 57 b8???????? e8???????? 83c40c 8bc6 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   57                   | push                edi
            //   b8????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8bc6                 | mov                 eax, esi

        $sequence_8 = { 8db348010000 7411 8b4604 83c001 99 b903000000 }
            // n = 6, score = 100
            //   8db348010000         | lea                 esi, [ebx + 0x148]
            //   7411                 | je                  0x13
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   83c001               | add                 eax, 1
            //   99                   | cdq                 
            //   b903000000           | mov                 ecx, 3

        $sequence_9 = { 0f8423ffffff 8b8604600000 50 ffd5 }
            // n = 4, score = 100
            //   0f8423ffffff         | je                  0xffffff29
            //   8b8604600000         | mov                 eax, dword ptr [esi + 0x6004]
            //   50                   | push                eax
            //   ffd5                 | call                ebp

    condition:
        7 of them and filesize < 81920
}