rule win_elise_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.elise."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.elise"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8dbe1e050000 f3ab 8bc2 0fb7d0 }
            // n = 4, score = 400
            //   8dbe1e050000         | lea                 edi, [esi + 0x51e]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8bc2                 | mov                 eax, edx
            //   0fb7d0               | movzx               edx, ax

        $sequence_1 = { 7205 8d0429 eb02 33c0 5f 5e }
            // n = 6, score = 400
            //   7205                 | jb                  7
            //   8d0429               | lea                 eax, [ecx + ebp]
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_2 = { 4e 237720 d3e6 59 }
            // n = 4, score = 400
            //   4e                   | dec                 esi
            //   237720               | and                 esi, dword ptr [edi + 0x20]
            //   d3e6                 | shl                 esi, cl
            //   59                   | pop                 ecx

        $sequence_3 = { 8b10 53 8a5c2408 8d4804 }
            // n = 4, score = 400
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   53                   | push                ebx
            //   8a5c2408             | mov                 bl, byte ptr [esp + 8]
            //   8d4804               | lea                 ecx, [eax + 4]

        $sequence_4 = { 7ce9 33c0 40 5b 5e 5f c3 }
            // n = 7, score = 400
            //   7ce9                 | jl                  0xffffffeb
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   5b                   | pop                 ebx
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi
            //   c3                   | ret                 

        $sequence_5 = { 8bc6 e8???????? 85c0 0f8484000000 53 }
            // n = 5, score = 400
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8484000000         | je                  0x8a
            //   53                   | push                ebx

        $sequence_6 = { 55 33c9 57 ba00040000 85c0 760e }
            // n = 6, score = 400
            //   55                   | push                ebp
            //   33c9                 | xor                 ecx, ecx
            //   57                   | push                edi
            //   ba00040000           | mov                 edx, 0x400
            //   85c0                 | test                eax, eax
            //   760e                 | jbe                 0x10

        $sequence_7 = { 8bcb 8d3470 d3e0 0945f4 43 83fb04 }
            // n = 6, score = 400
            //   8bcb                 | mov                 ecx, ebx
            //   8d3470               | lea                 esi, [eax + esi*2]
            //   d3e0                 | shl                 eax, cl
            //   0945f4               | or                  dword ptr [ebp - 0xc], eax
            //   43                   | inc                 ebx
            //   83fb04               | cmp                 ebx, 4

        $sequence_8 = { 7cf5 33c9 888f00010000 888f01010000 8bf7 8945f8 }
            // n = 6, score = 400
            //   7cf5                 | jl                  0xfffffff7
            //   33c9                 | xor                 ecx, ecx
            //   888f00010000         | mov                 byte ptr [edi + 0x100], cl
            //   888f01010000         | mov                 byte ptr [edi + 0x101], cl
            //   8bf7                 | mov                 esi, edi
            //   8945f8               | mov                 dword ptr [ebp - 8], eax

        $sequence_9 = { 885d88 e8???????? 83c40c 8d4580 }
            // n = 4, score = 300
            //   885d88               | mov                 byte ptr [ebp - 0x78], bl
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d4580               | lea                 eax, [ebp - 0x80]

        $sequence_10 = { 33f6 46 d3e6 0bd6 40 83f80e 72e7 }
            // n = 7, score = 300
            //   33f6                 | xor                 esi, esi
            //   46                   | inc                 esi
            //   d3e6                 | shl                 esi, cl
            //   0bd6                 | or                  edx, esi
            //   40                   | inc                 eax
            //   83f80e               | cmp                 eax, 0xe
            //   72e7                 | jb                  0xffffffe9

        $sequence_11 = { ff15???????? eb0b 6a02 53 53 }
            // n = 5, score = 300
            //   ff15????????         |                     
            //   eb0b                 | jmp                 0xd
            //   6a02                 | push                2
            //   53                   | push                ebx
            //   53                   | push                ebx

        $sequence_12 = { ff75ec 1155f4 53 e8???????? 8bd8 8955ec }
            // n = 6, score = 300
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   1155f4               | adc                 dword ptr [ebp - 0xc], edx
            //   53                   | push                ebx
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   8955ec               | mov                 dword ptr [ebp - 0x14], edx

        $sequence_13 = { 56 57 b99a000000 8d7510 }
            // n = 4, score = 300
            //   56                   | push                esi
            //   57                   | push                edi
            //   b99a000000           | mov                 ecx, 0x9a
            //   8d7510               | lea                 esi, [ebp + 0x10]

        $sequence_14 = { eb03 8b7df4 8d4e01 81e1ff000080 7908 49 }
            // n = 6, score = 300
            //   eb03                 | jmp                 5
            //   8b7df4               | mov                 edi, dword ptr [ebp - 0xc]
            //   8d4e01               | lea                 ecx, [esi + 1]
            //   81e1ff000080         | and                 ecx, 0x800000ff
            //   7908                 | jns                 0xa
            //   49                   | dec                 ecx

        $sequence_15 = { 6a20 e8???????? 59 8bd8 }
            // n = 4, score = 300
            //   6a20                 | push                0x20
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8bd8                 | mov                 ebx, eax

        $sequence_16 = { 46 4f 75eb f7d0 5f 5e }
            // n = 6, score = 300
            //   46                   | inc                 esi
            //   4f                   | dec                 edi
            //   75eb                 | jne                 0xffffffed
            //   f7d0                 | not                 eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_17 = { 83c40c 8d4580 50 8d4588 50 53 }
            // n = 6, score = 300
            //   83c40c               | add                 esp, 0xc
            //   8d4580               | lea                 eax, [ebp - 0x80]
            //   50                   | push                eax
            //   8d4588               | lea                 eax, [ebp - 0x78]
            //   50                   | push                eax
            //   53                   | push                ebx

        $sequence_18 = { 85ff 7415 0fb616 33d0 23d1 }
            // n = 5, score = 300
            //   85ff                 | test                edi, edi
            //   7415                 | je                  0x17
            //   0fb616               | movzx               edx, byte ptr [esi]
            //   33d0                 | xor                 edx, eax
            //   23d1                 | and                 edx, ecx

        $sequence_19 = { 50 ff7580 e8???????? 85c0 }
            // n = 4, score = 300
            //   50                   | push                eax
            //   ff7580               | push                dword ptr [ebp - 0x80]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_20 = { 59 8b45f0 8b55f4 5f 5e 5b c9 }
            // n = 7, score = 300
            //   59                   | pop                 ecx
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c9                   | leave               

    condition:
        7 of them and filesize < 204800
}