rule win_emdivi_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.emdivi."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.emdivi"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c1e304 83e203 3355f8 33fb }
            // n = 4, score = 300
            //   c1e304               | shl                 ebx, 4
            //   83e203               | and                 edx, 3
            //   3355f8               | xor                 edx, dword ptr [ebp - 8]
            //   33fb                 | xor                 edi, ebx

        $sequence_1 = { 53 50 889decfaffff e8???????? 83c40c 56 }
            // n = 6, score = 300
            //   53                   | push                ebx
            //   50                   | push                eax
            //   889decfaffff         | mov                 byte ptr [ebp - 0x514], bl
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   56                   | push                esi

        $sequence_2 = { 53 56 57 8bf8 83ff01 0f8ec5000000 }
            // n = 6, score = 300
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf8                 | mov                 edi, eax
            //   83ff01               | cmp                 edi, 1
            //   0f8ec5000000         | jle                 0xcb

        $sequence_3 = { 50 e8???????? 83c40c 56 8d85b4fdffff 53 50 }
            // n = 7, score = 300
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   56                   | push                esi
            //   8d85b4fdffff         | lea                 eax, [ebp - 0x24c]
            //   53                   | push                ebx
            //   50                   | push                eax

        $sequence_4 = { 8945e4 e8???????? 8bd8 8bc6 59 c6432000 }
            // n = 6, score = 300
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   8bc6                 | mov                 eax, esi
            //   59                   | pop                 ecx
            //   c6432000             | mov                 byte ptr [ebx + 0x20], 0

        $sequence_5 = { 0f849b000000 8b4d08 83c604 ff45f8 85c9 7409 394df8 }
            // n = 7, score = 300
            //   0f849b000000         | je                  0xa1
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   83c604               | add                 esi, 4
            //   ff45f8               | inc                 dword ptr [ebp - 8]
            //   85c9                 | test                ecx, ecx
            //   7409                 | je                  0xb
            //   394df8               | cmp                 dword ptr [ebp - 8], ecx

        $sequence_6 = { 8975ec 8b03 8945f0 8b4304 8945f4 }
            // n = 5, score = 300
            //   8975ec               | mov                 dword ptr [ebp - 0x14], esi
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8b4304               | mov                 eax, dword ptr [ebx + 4]
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax

        $sequence_7 = { 03fb 33fa 2939 8b31 054786c861 8945fc 0f856effffff }
            // n = 7, score = 300
            //   03fb                 | add                 edi, ebx
            //   33fa                 | xor                 edi, edx
            //   2939                 | sub                 dword ptr [ecx], edi
            //   8b31                 | mov                 esi, dword ptr [ecx]
            //   054786c861           | add                 eax, 0x61c88647
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   0f856effffff         | jne                 0xffffff74

        $sequence_8 = { a1???????? 33c5 8945fc 8365d000 803e00 }
            // n = 5, score = 300
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8365d000             | and                 dword ptr [ebp - 0x30], 0
            //   803e00               | cmp                 byte ptr [esi], 0

        $sequence_9 = { ff75b8 8d45bc 6a40 6a01 50 e8???????? }
            // n = 6, score = 300
            //   ff75b8               | push                dword ptr [ebp - 0x48]
            //   8d45bc               | lea                 eax, [ebp - 0x44]
            //   6a40                 | push                0x40
            //   6a01                 | push                1
            //   50                   | push                eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 581632
}