rule win_evilgrab_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.evilgrab."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.evilgrab"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 8b4324 8d0c40 c1e105 03c8 8d1488 8b4328 }
            // n = 7, score = 200
            //   57                   | push                edi
            //   8b4324               | mov                 eax, dword ptr [ebx + 0x24]
            //   8d0c40               | lea                 ecx, [eax + eax*2]
            //   c1e105               | shl                 ecx, 5
            //   03c8                 | add                 ecx, eax
            //   8d1488               | lea                 edx, [eax + ecx*4]
            //   8b4328               | mov                 eax, dword ptr [ebx + 0x28]

        $sequence_1 = { ffd6 83c408 eb06 8b35???????? 8d8c2484030000 68???????? 51 }
            // n = 7, score = 200
            //   ffd6                 | call                esi
            //   83c408               | add                 esp, 8
            //   eb06                 | jmp                 8
            //   8b35????????         |                     
            //   8d8c2484030000       | lea                 ecx, [esp + 0x384]
            //   68????????           |                     
            //   51                   | push                ecx

        $sequence_2 = { ff15???????? 89b338050000 897308 897304 89730c bf3f000000 }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   89b338050000         | mov                 dword ptr [ebx + 0x538], esi
            //   897308               | mov                 dword ptr [ebx + 8], esi
            //   897304               | mov                 dword ptr [ebx + 4], esi
            //   89730c               | mov                 dword ptr [ebx + 0xc], esi
            //   bf3f000000           | mov                 edi, 0x3f

        $sequence_3 = { 6a00 6a01 ff15???????? 8bf8 897dec 85ff }
            // n = 6, score = 200
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   897dec               | mov                 dword ptr [ebp - 0x14], edi
            //   85ff                 | test                edi, edi

        $sequence_4 = { ebb3 8b75c8 8b4e10 51 e8???????? c74610ffffffff 8b45e8 }
            // n = 7, score = 200
            //   ebb3                 | jmp                 0xffffffb5
            //   8b75c8               | mov                 esi, dword ptr [ebp - 0x38]
            //   8b4e10               | mov                 ecx, dword ptr [esi + 0x10]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   c74610ffffffff       | mov                 dword ptr [esi + 0x10], 0xffffffff
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]

        $sequence_5 = { ff15???????? 83c40c ff8510ebffff 47 ebba 33f6 89b5d8e4ffff }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   ff8510ebffff         | inc                 dword ptr [ebp - 0x14f0]
            //   47                   | inc                 edi
            //   ebba                 | jmp                 0xffffffbc
            //   33f6                 | xor                 esi, esi
            //   89b5d8e4ffff         | mov                 dword ptr [ebp - 0x1b28], esi

        $sequence_6 = { e9???????? 8d8540fcffff 50 8d8d48fdffff 51 8d9548feffff 52 }
            // n = 7, score = 200
            //   e9????????           |                     
            //   8d8540fcffff         | lea                 eax, [ebp - 0x3c0]
            //   50                   | push                eax
            //   8d8d48fdffff         | lea                 ecx, [ebp - 0x2b8]
            //   51                   | push                ecx
            //   8d9548feffff         | lea                 edx, [ebp - 0x1b8]
            //   52                   | push                edx

        $sequence_7 = { ffd3 8b4628 50 ffd5 8b462c 85c0 }
            // n = 6, score = 200
            //   ffd3                 | call                ebx
            //   8b4628               | mov                 eax, dword ptr [esi + 0x28]
            //   50                   | push                eax
            //   ffd5                 | call                ebp
            //   8b462c               | mov                 eax, dword ptr [esi + 0x2c]
            //   85c0                 | test                eax, eax

        $sequence_8 = { ffd7 8b442418 50 6a40 ff15???????? 8b542418 8d4c2420 }
            // n = 7, score = 200
            //   ffd7                 | call                edi
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   50                   | push                eax
            //   6a40                 | push                0x40
            //   ff15????????         |                     
            //   8b542418             | mov                 edx, dword ptr [esp + 0x18]
            //   8d4c2420             | lea                 ecx, [esp + 0x20]

        $sequence_9 = { c685f0efffffd1 68???????? 8d8df1efffff 51 ff15???????? 83c408 8d95f0efffff }
            // n = 7, score = 200
            //   c685f0efffffd1       | mov                 byte ptr [ebp - 0x1010], 0xd1
            //   68????????           |                     
            //   8d8df1efffff         | lea                 ecx, [ebp - 0x100f]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   83c408               | add                 esp, 8
            //   8d95f0efffff         | lea                 edx, [ebp - 0x1010]

    condition:
        7 of them and filesize < 327680
}