rule win_excalibur_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.excalibur."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.excalibur"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3902 7518 8b442468 8b4c246c }
            // n = 4, score = 100
            //   3902                 | cmp                 dword ptr [edx], eax
            //   7518                 | jne                 0x1a
            //   8b442468             | mov                 eax, dword ptr [esp + 0x68]
            //   8b4c246c             | mov                 ecx, dword ptr [esp + 0x6c]

        $sequence_1 = { 894238 8b45d4 89423c 8b45d0 894240 5f }
            // n = 6, score = 100
            //   894238               | mov                 dword ptr [edx + 0x38], eax
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   89423c               | mov                 dword ptr [edx + 0x3c], eax
            //   8b45d0               | mov                 eax, dword ptr [ebp - 0x30]
            //   894240               | mov                 dword ptr [edx + 0x40], eax
            //   5f                   | pop                 edi

        $sequence_2 = { 744b 833f02 750e e8???????? c685bfe5ffff00 eb0c e8???????? }
            // n = 7, score = 100
            //   744b                 | je                  0x4d
            //   833f02               | cmp                 dword ptr [edi], 2
            //   750e                 | jne                 0x10
            //   e8????????           |                     
            //   c685bfe5ffff00       | mov                 byte ptr [ebp - 0x1a41], 0
            //   eb0c                 | jmp                 0xe
            //   e8????????           |                     

        $sequence_3 = { 32db 8bf1 85ff 7543 8b4d08 c70100000000 33d2 }
            // n = 7, score = 100
            //   32db                 | xor                 bl, bl
            //   8bf1                 | mov                 esi, ecx
            //   85ff                 | test                edi, edi
            //   7543                 | jne                 0x45
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   c70100000000         | mov                 dword ptr [ecx], 0
            //   33d2                 | xor                 edx, edx

        $sequence_4 = { 68e9fd0000 ffd3 83bd8cfbffff10 6a00 6a00 }
            // n = 5, score = 100
            //   68e9fd0000           | push                0xfde9
            //   ffd3                 | call                ebx
            //   83bd8cfbffff10       | cmp                 dword ptr [ebp - 0x474], 0x10
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_5 = { 8b4d08 81c144060000 ba04000000 894d08 be01000000 03f6 0fb70c0e }
            // n = 7, score = 100
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   81c144060000         | add                 ecx, 0x644
            //   ba04000000           | mov                 edx, 4
            //   894d08               | mov                 dword ptr [ebp + 8], ecx
            //   be01000000           | mov                 esi, 1
            //   03f6                 | add                 esi, esi
            //   0fb70c0e             | movzx               ecx, word ptr [esi + ecx]

        $sequence_6 = { 897c05ac eb2b 0f853e010000 85c9 0f8720010000 8b45e0 7208 }
            // n = 7, score = 100
            //   897c05ac             | mov                 dword ptr [ebp + eax - 0x54], edi
            //   eb2b                 | jmp                 0x2d
            //   0f853e010000         | jne                 0x144
            //   85c9                 | test                ecx, ecx
            //   0f8720010000         | ja                  0x126
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   7208                 | jb                  0xa

        $sequence_7 = { 8b75d8 8a5de7 f6c310 0f84b3000000 8d559c 8bce e8???????? }
            // n = 7, score = 100
            //   8b75d8               | mov                 esi, dword ptr [ebp - 0x28]
            //   8a5de7               | mov                 bl, byte ptr [ebp - 0x19]
            //   f6c310               | test                bl, 0x10
            //   0f84b3000000         | je                  0xb9
            //   8d559c               | lea                 edx, [ebp - 0x64]
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     

        $sequence_8 = { 83c404 33c0 83bd1cffffff08 c7854cffffff07000000 c78548ffffff00000000 66898538ffffff 720e }
            // n = 7, score = 100
            //   83c404               | add                 esp, 4
            //   33c0                 | xor                 eax, eax
            //   83bd1cffffff08       | cmp                 dword ptr [ebp - 0xe4], 8
            //   c7854cffffff07000000     | mov    dword ptr [ebp - 0xb4], 7
            //   c78548ffffff00000000     | mov    dword ptr [ebp - 0xb8], 0
            //   66898538ffffff       | mov                 word ptr [ebp - 0xc8], ax
            //   720e                 | jb                  0x10

        $sequence_9 = { 8d8d2cffffff c645fc08 e8???????? 57 8bd0 8d8d14ffffff }
            // n = 6, score = 100
            //   8d8d2cffffff         | lea                 ecx, [ebp - 0xd4]
            //   c645fc08             | mov                 byte ptr [ebp - 4], 8
            //   e8????????           |                     
            //   57                   | push                edi
            //   8bd0                 | mov                 edx, eax
            //   8d8d14ffffff         | lea                 ecx, [ebp - 0xec]

    condition:
        7 of them and filesize < 1253376
}