rule win_fanny_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.fanny."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fanny"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b45d4 50 e8???????? 8945fc 8b4dfc }
            // n = 5, score = 200
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_1 = { 8d4dd8 e8???????? 8b45b0 eb1a c745ac01000000 }
            // n = 5, score = 200
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   e8????????           |                     
            //   8b45b0               | mov                 eax, dword ptr [ebp - 0x50]
            //   eb1a                 | jmp                 0x1c
            //   c745ac01000000       | mov                 dword ptr [ebp - 0x54], 1

        $sequence_2 = { 897c2410 56 e8???????? 8b442414 83c404 }
            // n = 5, score = 200
            //   897c2410             | mov                 dword ptr [esp + 0x10], edi
            //   56                   | push                esi
            //   e8????????           |                     
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   83c404               | add                 esp, 4

        $sequence_3 = { 85c9 7615 8bd9 b801010101 8bfe }
            // n = 5, score = 200
            //   85c9                 | test                ecx, ecx
            //   7615                 | jbe                 0x17
            //   8bd9                 | mov                 ebx, ecx
            //   b801010101           | mov                 eax, 0x1010101
            //   8bfe                 | mov                 edi, esi

        $sequence_4 = { 50 ffd3 85c0 59 894604 }
            // n = 5, score = 200
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   85c0                 | test                eax, eax
            //   59                   | pop                 ecx
            //   894604               | mov                 dword ptr [esi + 4], eax

        $sequence_5 = { 5d c20800 55 8bec 81ec38020000 }
            // n = 5, score = 200
            //   5d                   | pop                 ebp
            //   c20800               | ret                 8
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec38020000         | sub                 esp, 0x238

        $sequence_6 = { ffd6 c645f863 bf00020000 807dfe28 0f838f000000 33db 57 }
            // n = 7, score = 200
            //   ffd6                 | call                esi
            //   c645f863             | mov                 byte ptr [ebp - 8], 0x63
            //   bf00020000           | mov                 edi, 0x200
            //   807dfe28             | cmp                 byte ptr [ebp - 2], 0x28
            //   0f838f000000         | jae                 0x95
            //   33db                 | xor                 ebx, ebx
            //   57                   | push                edi

        $sequence_7 = { 8b7d00 8bf0 8bc1 c1e902 f3a5 8bc8 33c0 }
            // n = 7, score = 200
            //   8b7d00               | mov                 edi, dword ptr [ebp]
            //   8bf0                 | mov                 esi, eax
            //   8bc1                 | mov                 eax, ecx
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bc8                 | mov                 ecx, eax
            //   33c0                 | xor                 eax, eax

        $sequence_8 = { 6a00 89450c 8d450c 50 ff75f8 53 }
            // n = 6, score = 200
            //   6a00                 | push                0
            //   89450c               | mov                 dword ptr [ebp + 0xc], eax
            //   8d450c               | lea                 eax, [ebp + 0xc]
            //   50                   | push                eax
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   53                   | push                ebx

        $sequence_9 = { 83c414 85c0 7508 0fb745fc 85c0 7403 }
            // n = 6, score = 200
            //   83c414               | add                 esp, 0x14
            //   85c0                 | test                eax, eax
            //   7508                 | jne                 0xa
            //   0fb745fc             | movzx               eax, word ptr [ebp - 4]
            //   85c0                 | test                eax, eax
            //   7403                 | je                  5

        $sequence_10 = { 8d9e18020000 8d54240c 52 8d542418 }
            // n = 4, score = 200
            //   8d9e18020000         | lea                 ebx, [esi + 0x218]
            //   8d54240c             | lea                 edx, [esp + 0xc]
            //   52                   | push                edx
            //   8d542418             | lea                 edx, [esp + 0x18]

        $sequence_11 = { 53 56 57 8965e8 33db 895dc0 b907000000 }
            // n = 7, score = 200
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8965e8               | mov                 dword ptr [ebp - 0x18], esp
            //   33db                 | xor                 ebx, ebx
            //   895dc0               | mov                 dword ptr [ebp - 0x40], ebx
            //   b907000000           | mov                 ecx, 7

        $sequence_12 = { 7517 8b842418010000 8938 5f 5e 33c0 }
            // n = 6, score = 200
            //   7517                 | jne                 0x19
            //   8b842418010000       | mov                 eax, dword ptr [esp + 0x118]
            //   8938                 | mov                 dword ptr [eax], edi
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   33c0                 | xor                 eax, eax

        $sequence_13 = { 66894dc8 b906000000 33c0 8d7da8 f3ab c745a808000000 }
            // n = 6, score = 200
            //   66894dc8             | mov                 word ptr [ebp - 0x38], cx
            //   b906000000           | mov                 ecx, 6
            //   33c0                 | xor                 eax, eax
            //   8d7da8               | lea                 edi, [ebp - 0x58]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   c745a808000000       | mov                 dword ptr [ebp - 0x58], 8

        $sequence_14 = { c745bc00000000 8d4dec e8???????? 8d4dd8 e8???????? }
            // n = 5, score = 200
            //   c745bc00000000       | mov                 dword ptr [ebp - 0x44], 0
            //   8d4dec               | lea                 ecx, [ebp - 0x14]
            //   e8????????           |                     
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   e8????????           |                     

        $sequence_15 = { ff33 ff15???????? 832300 59 8b45fc 5f 5e }
            // n = 7, score = 200
            //   ff33                 | push                dword ptr [ebx]
            //   ff15????????         |                     
            //   832300               | and                 dword ptr [ebx], 0
            //   59                   | pop                 ecx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

    condition:
        7 of them and filesize < 368640
}