rule win_farseer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.farseer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.farseer"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83f804 770c 6a06 68???????? e9???????? 83f805 0f8590000000 }
            // n = 7, score = 100
            //   83f804               | cmp                 eax, 4
            //   770c                 | ja                  0xe
            //   6a06                 | push                6
            //   68????????           |                     
            //   e9????????           |                     
            //   83f805               | cmp                 eax, 5
            //   0f8590000000         | jne                 0x96

        $sequence_1 = { 8b4514 40 c745eceab84000 894df8 8945fc 64a100000000 8945e8 }
            // n = 7, score = 100
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   40                   | inc                 eax
            //   c745eceab84000       | mov                 dword ptr [ebp - 0x14], 0x40b8ea
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   64a100000000         | mov                 eax, dword ptr fs:[0]
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax

        $sequence_2 = { 399c24e0000000 7307 8d8424cc000000 50 8d4c2444 e8???????? 85c0 }
            // n = 7, score = 100
            //   399c24e0000000       | cmp                 dword ptr [esp + 0xe0], ebx
            //   7307                 | jae                 9
            //   8d8424cc000000       | lea                 eax, [esp + 0xcc]
            //   50                   | push                eax
            //   8d4c2444             | lea                 ecx, [esp + 0x44]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_3 = { c1e106 030cbd20634200 eb02 8bca }
            // n = 4, score = 100
            //   c1e106               | shl                 ecx, 6
            //   030cbd20634200       | add                 ecx, dword ptr [edi*4 + 0x426320]
            //   eb02                 | jmp                 4
            //   8bca                 | mov                 ecx, edx

        $sequence_4 = { c1e006 03049520634200 eb05 b8???????? f6400420 7414 }
            // n = 6, score = 100
            //   c1e006               | shl                 eax, 6
            //   03049520634200       | add                 eax, dword ptr [edx*4 + 0x426320]
            //   eb05                 | jmp                 7
            //   b8????????           |                     
            //   f6400420             | test                byte ptr [eax + 4], 0x20
            //   7414                 | je                  0x16

        $sequence_5 = { ffd5 85c0 7e2f 03f0 81fe00040000 7ce1 33c0 }
            // n = 7, score = 100
            //   ffd5                 | call                ebp
            //   85c0                 | test                eax, eax
            //   7e2f                 | jle                 0x31
            //   03f0                 | add                 esi, eax
            //   81fe00040000         | cmp                 esi, 0x400
            //   7ce1                 | jl                  0xffffffe3
            //   33c0                 | xor                 eax, eax

        $sequence_6 = { 50 8d0c3e 51 53 }
            // n = 4, score = 100
            //   50                   | push                eax
            //   8d0c3e               | lea                 ecx, [esi + edi]
            //   51                   | push                ecx
            //   53                   | push                ebx

        $sequence_7 = { 85c0 757a 8b5c2424 8d751c 3bf3 }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   757a                 | jne                 0x7c
            //   8b5c2424             | mov                 ebx, dword ptr [esp + 0x24]
            //   8d751c               | lea                 esi, [ebp + 0x1c]
            //   3bf3                 | cmp                 esi, ebx

        $sequence_8 = { 895604 894608 8d842458020000 8d5001 8d4900 8a08 }
            // n = 6, score = 100
            //   895604               | mov                 dword ptr [esi + 4], edx
            //   894608               | mov                 dword ptr [esi + 8], eax
            //   8d842458020000       | lea                 eax, [esp + 0x258]
            //   8d5001               | lea                 edx, [eax + 1]
            //   8d4900               | lea                 ecx, [ecx]
            //   8a08                 | mov                 cl, byte ptr [eax]

        $sequence_9 = { 3bc1 0f87ad090000 ff24851d094100 838de8fdffffff 89b590fdffff }
            // n = 5, score = 100
            //   3bc1                 | cmp                 eax, ecx
            //   0f87ad090000         | ja                  0x9b3
            //   ff24851d094100       | jmp                 dword ptr [eax*4 + 0x41091d]
            //   838de8fdffffff       | or                  dword ptr [ebp - 0x218], 0xffffffff
            //   89b590fdffff         | mov                 dword ptr [ebp - 0x270], esi

    condition:
        7 of them and filesize < 347328
}