rule win_fct_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.fct."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fct"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7515 8b4510 81784860504100 7409 ff7048 }
            // n = 5, score = 100
            //   7515                 | jne                 0x17
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   81784860504100       | cmp                 dword ptr [eax + 0x48], 0x415060
            //   7409                 | je                  0xb
            //   ff7048               | push                dword ptr [eax + 0x48]

        $sequence_1 = { c1f906 6bd038 8b45fc 03148d50614100 8b00 894218 }
            // n = 6, score = 100
            //   c1f906               | sar                 ecx, 6
            //   6bd038               | imul                edx, eax, 0x38
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   03148d50614100       | add                 edx, dword ptr [ecx*4 + 0x416150]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   894218               | mov                 dword ptr [edx + 0x18], eax

        $sequence_2 = { 7313 8a8788544100 08441619 42 0fb64101 }
            // n = 5, score = 100
            //   7313                 | jae                 0x15
            //   8a8788544100         | mov                 al, byte ptr [edi + 0x415488]
            //   08441619             | or                  byte ptr [esi + edx + 0x19], al
            //   42                   | inc                 edx
            //   0fb64101             | movzx               eax, byte ptr [ecx + 1]

        $sequence_3 = { 83f81d 7cf1 eb07 8b0cc59c3a4100 894de4 }
            // n = 5, score = 100
            //   83f81d               | cmp                 eax, 0x1d
            //   7cf1                 | jl                  0xfffffff3
            //   eb07                 | jmp                 9
            //   8b0cc59c3a4100       | mov                 ecx, dword ptr [eax*8 + 0x413a9c]
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx

        $sequence_4 = { d1f9 51 57 8d4dbc e8???????? c745fc00000000 }
            // n = 6, score = 100
            //   d1f9                 | sar                 ecx, 1
            //   51                   | push                ecx
            //   57                   | push                edi
            //   8d4dbc               | lea                 ecx, [ebp - 0x44]
            //   e8????????           |                     
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0

        $sequence_5 = { 75f5 8b5dec 2bca 8b55e8 8bc3 }
            // n = 5, score = 100
            //   75f5                 | jne                 0xfffffff7
            //   8b5dec               | mov                 ebx, dword ptr [ebp - 0x14]
            //   2bca                 | sub                 ecx, edx
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   8bc3                 | mov                 eax, ebx

        $sequence_6 = { 8d5102 668b01 83c102 6685c0 75f5 8b5dec }
            // n = 6, score = 100
            //   8d5102               | lea                 edx, [ecx + 2]
            //   668b01               | mov                 ax, word ptr [ecx]
            //   83c102               | add                 ecx, 2
            //   6685c0               | test                ax, ax
            //   75f5                 | jne                 0xfffffff7
            //   8b5dec               | mov                 ebx, dword ptr [ebp - 0x14]

        $sequence_7 = { 51 8d4da4 c745b400000000 c745b80f000000 c645a400 }
            // n = 5, score = 100
            //   51                   | push                ecx
            //   8d4da4               | lea                 ecx, [ebp - 0x5c]
            //   c745b400000000       | mov                 dword ptr [ebp - 0x4c], 0
            //   c745b80f000000       | mov                 dword ptr [ebp - 0x48], 0xf
            //   c645a400             | mov                 byte ptr [ebp - 0x5c], 0

        $sequence_8 = { ffb54cfdffff 6a02 e8???????? 837dd008 }
            // n = 4, score = 100
            //   ffb54cfdffff         | push                dword ptr [ebp - 0x2b4]
            //   6a02                 | push                2
            //   e8????????           |                     
            //   837dd008             | cmp                 dword ptr [ebp - 0x30], 8

        $sequence_9 = { 8d8d34fdffff ffb514fdffff 50 e8???????? }
            // n = 4, score = 100
            //   8d8d34fdffff         | lea                 ecx, [ebp - 0x2cc]
            //   ffb514fdffff         | push                dword ptr [ebp - 0x2ec]
            //   50                   | push                eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 204800
}